function [distance_val model_momm]=distance_function(distance_param,data_momm,wtmat)

global rho_cshock_val rho_nshock_val rho_gov_val eta_val metanu_val std_ahshock std_ashock assemmetasigma_val

global M_ oo_


std_nshock = distance_param(1);    
std_cshock = distance_param(2);
std_govshock = distance_param(3);
rho_nshock_val = distance_param(4);
rho_cshock_val = distance_param(5);
rho_gov_val = distance_param(6);
eta_val = distance_param(7);
assemmetasigma_val = distance_param(8);  % elasticity of substitution between inputs in the assembly functions
metanu_val = distance_param(9);          % investment adjustment costs

%assemmetasigma_val = distance_param(9);  % elasticity of substitution in the assembly functions
%std_ashock = distance_param(10);
%std_ahshock = distance_param(11);


if (rho_cshock_val<1 && rho_cshock_val>0 && ...
    rho_nshock_val<1 && rho_nshock_val>0 && ...
    rho_gov_val<1 && rho_gov_val >0 &&...
    std_cshock > 0 && std_nshock>0 && std_govshock>0 && std_ashock>0 && std_ahshock>0 &&...
    eta_val>0 && eta_val<1 &&...
    metanu_val> 0  && metanu_val <10 &&...
    assemmetasigma_val>0 )


try

% call Dynare processed file    
ghk_labor2


dr_ = oo_.dr;
ys_ = oo_.dr.ys;
lgy_ = M_.endo_names;
lgx_ = M_.exo_names;

shock = [
std_ahshock%eps_ah    
0%eps_al    
0%eps_zeh   
0%eps_zel   
0%eps_zsh   
0%eps_zsl   
0%eps_gh    
0%eps_gl    
std_nshock%eps_nshock
std_cshock%eps_cshock
std_ashock%eps_a     
std_govshock%eps_gov          
];


dset = 'f0';
nperiods = 2000;
std_mat = diag(shock);
errlist = char('eps_ah','eps_a','eps_cshock','eps_gov','eps_nshock');
randn('seed',1); 
makedata

model_dataset = [f0_grpjepc_data ,f0_glabprod_data ,f0_n_agg_data ,f0_gj_cp_data, f0_gc_cp_data];
model_dataset = model_dataset-kron((mean(model_dataset)),ones(size(model_dataset,1),1));

%model_dataset = [f0_n_agg_data ,f0_gj_cp_data, f0_gc_cp_data];


optwt = 0; % no weighting function computed
[model_momm] = wtm_rm_noskew_opt(model_dataset,optwt);


distance_val = (model_momm-data_momm)'*wtmat*(model_momm-data_momm);
catch
model_momm = nan;
distance_val = 100000;   
end

else
model_momm = nan;
distance_val = 100000;
end

