clear all
setpath_windows


% list of observables and shocks for the ABCD test
obs_list =  char('g_p_m', 'glabprod', 'l','g_c','g_invest');
shock_list = char('eps_v', 'eps_a_m', 'eps_neutral','eps_govc','eps_betavar');

parse_switch = 1;
if parse_switch 
    dynare smallmod4  noclearall nolog
else
    smallmod4
end


dr_ = oo_.dr;
ys_ = oo_.dr.ys;
lgy_ = M_.endo_names;
lgx_ = M_.exo_names;
if isfield(M_,'nstatic')
    nstatic = M_.nstatic;
    nfwrd = M_.nfwrd;
else
    nstatic = dr_.nstatic;
    nfwrd = dr_.nfwrd;
end

[p,q]=get_pq(dr_,nstatic,nfwrd);


% make sure that P and Q are correct -- for instance, compute an IRF.



nobs = size(obs_list,1);
obs_selector_matrix = zeros(nobs,M_.endo_nbr);
for this_var = 1:nobs
    var_pos = strmatch(deblank(obs_list(this_var,:)),M_.endo_names,'exact');
    if ~isempty(var_pos)
    obs_selector_matrix(this_var,var_pos) = 1;
    else
        error('Variable in observed list not found')
    end
end


nshocks = size(shock_list,1);
shock_column_selector = zeros(nshocks,1);
for this_shock = 1:nobs
    shock_column_selector(this_shock) = strmatch(deblank(shock_list(this_shock,:)),M_.exo_names,'exact');
end

amat = p;
bmat = q(:,shock_column_selector);
cmat = obs_selector_matrix*amat;
dmat = obs_selector_matrix*bmat;

check_mat = amat-bmat*(dmat\cmat);


display(['The maximum eigenvalue for the ABCD test is ',num2str(max(abs(eig(check_mat))))])

