clear all
setpath_windows

%% Run model
parse_switch = 1;


if parse_switch 
    dynare smallmod4  noclearall nolog
else
    smallmod4
end

%ghk_labor2

dr_ = oo_.dr;
ys_ = oo_.dr.ys;
lgy_ = M_.endo_names;
lgx_ = M_.exo_names;
if isfield(M_,'nstatic')
    nstatic = M_.nstatic;
    nfwrd = M_.nfwrd;
else
    nstatic = dr_.nstatic;
    nfwrd = dr_.nfwrd;
end

[p,q]=get_pq(dr_,nstatic,nfwrd);
qcol_ah = q(:,strmatch('eps_a_m',lgx_,'exact'));              

% simulation horizon
nperiods = 100;

nperiods_long = 100;
% shorter simulation horizon for plotting (needs to be less than or
% equal to nperiods)
nperiods_short = 20;


std_a_m_shock = 0.01/0.581*2.951;
std_neutral_shock = 0.01*0.3696;

% continue from here
std_v_shock = 0.1198;
std_govc_shock = 0.0319;
std_betavar_shock = 0.0002;

shock = [0  % v
    0    % a_m
    0    %a_n
    std_neutral_shock % neutral
    0
    0
    0]';    
order = 1;
f2=makeirfsecondorder(M_,oo_,nperiods,shock,order);




shock = [0  %v
    std_a_m_shock   %a_m
    0      % a_n
    0
    0
    0
    0]'; % neutral         

f3=makeirfsecondorder(M_,oo_,nperiods,shock,order);




%%
legendlist = char('Neutral MFP shock',...
                  'MFP shock in the Machinery Sector');
figtitle = [''];

%% IRFs
% titles for each panel
titlelist = char('Agg. Output (at constant prices)','Labor Productivity',...
                 'Relative Price of Equipment Investment','Hours Worked',...
                 'Investment','Consumption');
             
% labels for y axis in each panel
ylabels = char('Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.');           
           
           

% needs to match order in titlelist           
first_line = 100*[f2.y_cp_irf/f2.y_cp_ss f2.labprod_irf/f2.labprod_ss...
                         f2.p_m_irf/f2.p_m_ss f2.l_irf/f2.l_ss ...
                         f2.invest_irf/f2.invest_ss f2.c_irf/f2.c_ss];
second_line = 100*[f3.y_cp_irf/f3.y_cp_ss f3.labprod_irf/f3.labprod_ss...
                         f3.p_m_irf/f3.p_m_ss f3.l_irf/f3.l_ss...
                         f3.invest_irf/f3.invest_ss f3.c_irf/f3.c_ss];
                     
% needs to match number of entries and order of variables included in
% first_line (and second and third line if present).
horizons = [nperiods_long,nperiods_long,...
            nperiods_long,nperiods_long,...
            nperiods_long,nperiods_long];


makechartmix2(titlelist,legendlist,figtitle,first_line,second_line,nan*first_line,horizons,ylabels)

%% IRFs
% titles for each panel
titlelist = char('Agg. Output (at constant prices)','Labor Productivity',...
                 'Relative Price of Equipment Investment','Hours Worked',...
                 'Investment','Consumption');
             
% labels for y axis in each panel
ylabels = char('Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.');           
           
           

% needs to match order in titlelist           
first_line = 100*[f2.y_cp_irf/f2.y_cp_ss f2.labprod_irf/f2.labprod_ss...
                         f2.p_m_irf/f2.p_m_ss f2.l_irf/f2.l_ss ...
                         f2.invest_irf/f2.invest_ss f2.c_irf/f2.c_ss];
second_line = 100*[f3.y_cp_irf/f3.y_cp_ss f3.labprod_irf/f3.labprod_ss...
                         f3.p_m_irf/f3.p_m_ss f3.l_irf/f3.l_ss...
                         f3.invest_irf/f3.invest_ss f3.c_irf/f3.c_ss];
                     
% needs to match number of entries and order of variables included in
% first_line (and second and third line if present).
horizons = [nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short];


makechartmix2(titlelist,legendlist,figtitle,first_line,second_line,nan*first_line,horizons,ylabels)


%% second figure sectoral details
% titles for each panel
titlelist = char('M-sector Output','N-sector Output',...
                 'M-sector Hours Worked','N-sector Hours Worked',...
                 'M-sector technoloty','N-sector technology');
             
% labels for y axis in each panel
ylabels = char('Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.',...
               'Percent Dev. From S.S.','Percent Dev. From S.S.');           
           
           

% needs to match order in titlelist           
first_line = 100*[f2.y_m_irf/f2.y_m_ss f2.y_n_irf/f2.y_n_ss...
                         f2.l_m_irf/f2.l_m_ss f2.l_n_irf/f2.l_n_ss ...
                         f2.a_m_irf f2.a_n_irf];
second_line = 100*[f3.y_m_irf/f3.y_m_ss f3.y_n_irf/f3.y_n_ss...
                         f3.l_m_irf/f3.l_m_ss f3.l_n_irf/f3.l_n_ss ...
                         f3.a_m_irf f3.a_n_irf];  
% needs to match number of entries and order of variables included in
% first_line (and second and third line if present).
horizons = [nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short,...
            nperiods_short,nperiods_short];


makechartmix2(titlelist,legendlist,figtitle,first_line,second_line,nan*first_line,horizons,ylabels)

model_data = [f3.p_m_irf ...
            f3.labprod_irf/f3.labprod_ss...
            f3.l_irf/f3.l_ss...
            f3.y_cp_irf/f3.y_cp_ss...
            f3.invest_irf/f3.invest_ss...
            f3.c_irf/f3.c_ss];





dr_ = oo_.dr;
ys_ = oo_.dr.ys;
lgy_ = M_.endo_names;
lgx_ = M_.exo_names;

shock = [
0       % eps_v      
0.01 %0.01/0.581*3.25      % eps_a_m    
0           % eps_a_n    
0 % eps_neutral
0    % eps_govc   
0    % eps_govi            
0];


dset = 'f0';
nperiods = 5000;
std_mat = diag(shock);
randn('seed',1); 
makedata

model_consumption_bc = bpass(f0_c_data,6,32);
model_investment_bc = bpass(f0_invest_data,6,32);

mei_corr = corrcoef(model_investment_bc,...
           model_consumption_bc );
     
shock = [
0       % eps_v      
0 %0.01/0.581*3.25      % eps_a_m    
0           % eps_a_n    
0.01 % eps_neutral
0    % eps_govc   
0    % eps_govi            
0];


dset = 'f0';
nperiods = 5000;
std_mat = diag(shock);
randn('seed',1); 
makedata

model_consumption_bc = bpass(f0_c_data,6,32);
model_investment_bc = bpass(f0_invest_data,6,32);

neutral_corr = corrcoef(model_investment_bc,...
           model_consumption_bc );
      
save compare_var_data model_data p qcol_ah lgy_ ys_  mei_corr neutral_corr     
%% run through all the shocks used in the VAR

nperiods = 100;
varshocklist = char('eps_a_m','eps_neutral','eps_v','eps_govc','eps_betavar');
shocksize = [std_a_m_shock,std_neutral_shock,std_v_shock,std_govc_shock,std_betavar_shock];



nvarshock = size(varshocklist,1);
nshocks = size(lgx_,1);

nvars = 2;
line = zeros(nperiods,nvars,nvarshock);
for indexi = 1:nvarshock
    shock = zeros(1,nshocks);
    this_shock_pos = strmatch(varshocklist(indexi,:),lgx_,'exact');
    shock(this_shock_pos) = shocksize(indexi);
    f(indexi) = makeirfsecondorder(M_,oo_,nperiods,shock,order);
    line(:,:,indexi)=100*[f(indexi).p_m_irf/f(indexi).p_m_ss, f(indexi).labprod_irf/f(indexi).labprod_ss];
end

titlelist = char('Relative Price of Investment','Labor Productivity');
legendlist=char('Machinery MFP shock','Neutral MFP shock','Labor Supply Shock','Government Consumption Shock','Risk Premium Shock');
figlabel='';
percent = 'Percent Dev. From S.S.';
ylabels = char(percent,percent);
makechart(titlelist,legendlist,figlabel,ylabels,line(:,:,1),line(:,:,2),line(:,:,3),line(:,:,4),line(:,:,5))
makechart_landscape(titlelist,legendlist,figlabel,ylabels,line(:,:,1),line(:,:,2),line(:,:,3),line(:,:,4),line(:,:,5))

     
