
function [corr1ci_var_bc, corr2ci_var_bc] = corr_monte(coefs,errmat,y,varlag,nreps,nperiods,isconstant,iscontemp,yw,population_factor)

T = size(errmat,1);
neqs = size(errmat,2);

bad_draw=0;
corr1ci_var_bc  = zeros(nreps,1);
corr2ci_var_bc  = zeros(nreps,1);

for confindx=1:nreps
    display(['Correlation rep ',num2str(confindx)])
    if mod(confindx,50) == 0
        display(['Correlation rep number ',num2str(confindx)])
    end
    issingular=-1;
    
    %stay in while loop until artificial data is generated that leads a nonsingular VAR    
    while (issingular<0) % keep drawing a new monte carlo series until one is found
        % that produces a covariance stationary VAR
        
        %%% Sample with replacement from the fitted residuals
        errpos = round((T-1)*rand(T,1)+ones(T,1));
%         for posindx=1:T
%             errmonte(posindx,:)=errmat(errpos(posindx),:);
%         end
        errmonte=errmat(errpos,:);
        
        %%% Using VAR structure and bootstrapped residuals, compute new y data
        %ymonte = mkymonteg(y,coefs,errmonte);
        ymonte = mkymonte(y,coefs,errmonte);
        if (yw == 0) 
            %[coefsmonte,coverr,errmatmonte]=estimateg(varlag,ymonte);
            varlagmat = varlag*ones(neqs);
            startpos =1;
            endpos = size(ymonte,1);
            [coefsmonte,coverr,errmatmonte]=estimate(varlagmat,zeros(neqs),ones(neqs,1),ymonte,startpos,endpos);

            [cofbmonte,const_bmonte]=ols2ar(coefsmonte(1:end,:),isconstant,iscontemp);
            cofamonte = iscontemp*coefsmonte(1+isconstant:neqs+isconstant,:);
        else    
            [Amonte, a0monte, coverr] = ywestimate(ymonte,varlag);
            [cofbmonte,const_bmonte]=yw2ar(Amonte,a0monte);
            cofamonte = zeros(neqs);
        end
        
        cofainvmonte = (eye(neqs)-cofamonte)^(-1);
        cofcmonte=isconstant*cofainvmonte*const_bmonte; 
        
        
        [issingular] = singulartest(cofbmonte);
        if issingular < 0
            bad_draw = bad_draw + 1;
        end
        
    end  %end of while loop
    
    coverr = errmatmonte'*errmatmonte/size(errmatmonte,1);
    Vmat = zeros(neqs);
    for i = 1:varlag
        Vmat = Vmat - cofbmonte(:,:,i);
    end
    Vmat = Vmat+eye(neqs);
    Vmatinv = eye(neqs)/Vmat;

    [cholmat,pchol] = chol(Vmatinv*coverr*Vmatinv');
    A0inv = Vmat*cholmat';

    % 
    
    
%shock1

samplelength = nperiods*population_factor;

errpos = round((size(errmatmonte,1)-1)*rand(samplelength,1)+ones(samplelength,1));
errmatrep = errmatmonte(errpos,:);


A0=inv(A0inv);
ierrmatmonte = A0*errmatrep';
ierrmatmonte1 = 0*ierrmatmonte;
ierrmatmonte1(1,:) = ierrmatmonte(1,:);

ierrmatmonte2 = 0*ierrmatmonte;
ierrmatmonte2(2,:) = ierrmatmonte(2,:);

errmatmonte1 = A0inv*ierrmatmonte1;
repdata1 = mkymonte_0(y,coefsmonte,errmatmonte1');

errmatmonte2 = A0inv*ierrmatmonte2;
repdata2 = mkymonte_0(y,coefsmonte,errmatmonte2');


% compute the levels and correlations
investment1 = cumsum(repdata1(:,4));
consumption1 = cumsum(repdata1(:,5));

corrcoef_temp = corrcoef(bpass(consumption1,6,32),bpass(investment1,6,32));

corr1ci_var_bc(confindx) = corrcoef_temp(1,2);


investment2 = cumsum(repdata2(:,4));
consumption2 = cumsum(repdata2(:,5));

corrcoef_temp = corrcoef(bpass(consumption2,6,32),bpass(investment2,6,32));
corr2ci_var_bc(confindx) = corrcoef_temp(1,2);

    
end


