rm(list = ls())
library(tidyverse)
library(lubridate)
library(rlang)
source(here::here("codes","essay1_paths.R"))

# Prepare POF Data ---------

# Read POF
pof_fipe <- readRDS(paste0(essay1_data_processed,"/fipe/pof_fipe.rds"))

# Obtain deciles

deciles_fipe <- pof_fipe %>% 
  distinct(COD_DOM,RENDA) %>% 
  mutate(decile = cut(RENDA,
                      breaks = quantile (RENDA,probs = seq(0,1,by=0.1)),
                      labels = seq_len(10),
                      include.lowest = T,
                      na.rm = T),
         decile = as.numeric(decile)) %>% 
  select(-RENDA)

# Join deciles

pof_fipe <- pof_fipe %>% 
  left_join(deciles_fipe, by = "COD_DOM")

# Compute Weights at 1 digit ---------------

pof_fipe <- pof_fipe %>% 
  mutate(ipc_group = str_sub(ipc,1,1))

# Weights 1 digit

weights_fipe_1d_dec <- pof_fipe %>% 
  group_by(ipc_group,decile) %>%
  summarise(tot_exp_group = sum(VAL_PAG, na.rm = T)) %>% 
  group_by(decile) %>% 
  mutate(tot_exp_decile = sum(tot_exp_group, na.rm = T)) %>% 
  ungroup() %>% 
  mutate(weight = tot_exp_group/tot_exp_decile)

weights_fipe_1d_ag <- pof_fipe %>% 
  group_by(ipc_group) %>% 
  summarise(tot_exp_group = sum(VAL_PAG, na.rm = T)) %>% 
  ungroup() %>% 
  mutate(tot_exp = sum(tot_exp_group, na.rm = T),
         weight = tot_exp_group/tot_exp,
         decile = 11) # obs: decile 11 to indicate aggregate economy

weights_fipe_1d <- bind_rows(weights_fipe_1d_dec,weights_fipe_1d_ag) %>% 
  select_at(vars(-starts_with("tot")))

# Check if weights sum to 1
weights_fipe_1d %>% group_by(decile) %>% summarise(w = sum(weight)) %>% filter(!near(w,1)) # Zero obs

# Compute Weights at 7 digits -------------------

# Weights 7 digit

weights_fipe_7d_dec <- pof_fipe %>% 
  group_by(ipc,decile) %>%
  summarise(tot_exp_subitem = sum(VAL_PAG, na.rm = T)) %>% 
  group_by(decile) %>% 
  mutate(tot_exp_decile = sum(tot_exp_subitem, na.rm = T)) %>% 
  ungroup() %>% 
  mutate(weight = tot_exp_subitem/tot_exp_decile)

weights_fipe_7d_ag <- pof_fipe %>% 
  group_by(ipc) %>% 
  summarise(tot_exp_subitem = sum(VAL_PAG, na.rm = T)) %>% 
  ungroup() %>% 
  mutate(tot_exp = sum(tot_exp_subitem, na.rm = T),
         weight = tot_exp_subitem/tot_exp,
         decile = 11) # obs: decile 11 to indicate aggregate economy

weights_fipe_7d <- bind_rows(weights_fipe_7d_dec,weights_fipe_7d_ag) %>% 
  select_at(vars(-starts_with("tot")))

# Check if weights sum to 1
weights_fipe_7d %>% group_by(decile) %>% summarise(w = sum(weight)) %>% filter(!near(w,1)) # Zero obs

# Compute Weights at 7 digits by Household -------------------
weights_fipe_7d_hou <- pof_fipe %>% 
  group_by(ipc,COD_DOM) %>%
  summarise(tot_exp_subitem = sum(VAL_PAG, na.rm = T)) %>% 
  group_by(COD_DOM) %>% 
  mutate(tot_exp_decile = sum(tot_exp_subitem, na.rm = T)) %>% 
  ungroup() %>% 
  mutate(weight = tot_exp_subitem/tot_exp_decile) %>% 
  select_at(vars(-starts_with("tot")))

# Check if weights sum to 1
weights_fipe_7d_hou %>% group_by(COD_DOM) %>% summarise(w = sum(weight)) %>% filter(!near(w,1)) # Zero obs

# Save ------ 
saveRDS(weights_fipe_1d, paste0(essay1_data_processed,"/fipe/weights_fipe_1d_decile.rds"))
saveRDS(weights_fipe_7d, paste0(essay1_data_processed,"/fipe/weights_fipe_7d_decile.rds"))
saveRDS(weights_fipe_7d_hou, paste0(essay1_data_processed,"/fipe/weights_fipe_7d_household.rds"))
