rm(list = ls())
library(tidyverse)
library(here)
library(foreign)
library(readxl)
source(here::here("codes","essay1_paths.R"))

# Read Inflation Data

ipc_fipe <- read_excel(paste0(essay1_data_raw,"/fipe/ANO-2000-ate-sm24-2009-mensal.xls"),sheet="IMPRENSA") %>%
  rename(ipc_desc=2)

# correct names
date_names <- as.character(seq.Date(from=as.Date("2000-01-01"),to=as.Date("2009-06-01"),by="month"))
names(ipc_fipe)[3:116] <- date_names

ipc_fipe <- ipc_fipe %>% 
  mutate(ipc_desc = tolower(iconv(ipc_desc, from = 'UTF-8', to = 'ASCII//TRANSLIT')))

# Read correspondonce table

ipcfipe_pof_correspondence <- readRDS(paste0(essay1_data_processed,"/fipe/ipcfipe_pof_correspondence.rds"))

ipc_codes <- ipcfipe_pof_correspondence %>% 
  distinct(ipc_desc,ipc,level)

# Join
ipc_fipe <- ipc_fipe %>% 
  left_join(ipc_codes,by="ipc_desc") 

# Gather data and insert date in date format
ipc_fipe <- ipc_fipe %>% 
  gather(key = date_original,
         value = inflation,
         -c(codigo,ipc_desc,ipc,level)) %>% 
  mutate(date = as.Date(date_original)) 

# Obtain codes for subitems introduced in 2001
ipc_fipe_na <- ipc_fipe %>% 
  filter(is.na(inflation))

start_month <- ipc_fipe_na %>% 
  group_by(codigo,ipc,ipc_desc) %>% 
  summarise(min = min(date),
            max = max(date))

start_month_codes <- start_month %>% 
  pull(ipc)

# Create CPI and Rebase
ipc_fipe <- ipc_fipe %>% 
  group_by(ipc) %>% 
  arrange(ipc,date) %>% 
  mutate(cpi = cumprod(ifelse((date == "2000-01-01" & !(ipc %in% start_month_codes)),
                              1,
                              ifelse((date <= "2001-01-01" & (ipc %in% start_month_codes)),
                                     1,
                                     1+inflation/100))),
         cpi = ifelse(is.na(inflation),NA,cpi))

base_date <- "2002-04-01"
cpi_base <- ipc_fipe %>% 
  filter(date == base_date) %>% 
  select(ipc,cpi_base = cpi)

ipc_fipe <- ipc_fipe %>% 
  left_join(cpi_base, by = "ipc") %>% 
  mutate(cpi_new_base = cpi/cpi_base) %>% 
  ungroup() %>% 
  select(codigo,level,ipc,ipc_desc,date,inflation, cpi = cpi_new_base,cpi_base)

# Check if there are not mistakes
ipc_fipe %>% 
  group_by(ipc) %>%
  arrange(ipc,date) %>%   
  mutate(cpi_rel = (cpi/lag(cpi, order_by = date)),
         check_inf = inflation - (cpi_rel - 1)*100) %>% 
  filter(!near(check_inf,0))

# Save RDS
saveRDS(ipc_fipe,file=paste0(essay1_data_processed,"/fipe/ipc_fipe.rds"))
 
