rm(list = ls())
library(tidyverse)
library(readxl)
library(lubridate)
library(rlang)
source(here::here("codes","essay1_paths.R"))

# Read correspondonce table IPC-POF

ipcfipe_to_pof_rev2000 <- read_excel(paste0(essay1_data_raw,"/fipe/ipcfipe_to_pof_rev2000_copy_original.xls"),sheet="Planilha1")

ipcfipe_pof_correspondence <- ipcfipe_to_pof_rev2000 %>% 
  mutate(ipc_subitem = ifelse(nchar(ipc_subitem)==1,paste0("0",ipc_subitem),ipc_subitem),
         ipc_item = ifelse(nchar(ipc_item)==1, paste0("0",ipc_item),ipc_item),
         ipc = ifelse((ipc_subitem == "00" & ipc_item == "00" & ipc_subgroup == 0), ipc_group,
                      ifelse((ipc_subitem == "00" & ipc_item == "00" & ipc_subgroup != 0),
                             paste0(ipc_group,ipc_subgroup),
                             ifelse((ipc_subitem == "00" & ipc_item != "00" & ipc_subgroup != 0),
                                    paste0(ipc_group,ipc_subgroup,ipc_item),
                                    paste0(ipc_group,ipc_subgroup,ipc_item,ipc_subitem)))),
         level = nchar(ipc)) %>% 
  select(level,ipc,ipc_desc,PRODUTO,COD_PROD,COD_TIPO,COD_MAR) %>% 
  mutate_at(vars(-matches("PRODUTO|ipc_desc")),~as.numeric(.)) %>% 
  distinct()

# Read ipc_fipe codes

ipc_fipe <- read_excel(paste0(essay1_data_raw,"/fipe/ANO-2000-ate-sm24-2009-mensal.xls"),sheet="IMPRENSA") %>%
  select(codigo,ipc_desc=2) %>% 
  mutate(ipc_desc = tolower(iconv(ipc_desc, from = 'UTF-8', to = 'ASCII//TRANSLIT')))

# Join
ipcfipe_pof_correspondence <-  ipcfipe_pof_correspondence %>% 
  left_join(ipc_fipe, by = "ipc_desc")

# Save
saveRDS(ipcfipe_pof_correspondence,paste0(essay1_data_processed,"/fipe/ipcfipe_pof_correspondence.rds"))