rm(list = ls())
library(tidyverse)
library(here)
library(readxl)
library(lubridate)
library(magrittr)
source(here::here("codes","essay1_paths.R"))

varieties_prices <- readRDS(paste0(essay1_data_processed,"/fipe/varieties_prices.rds"))

# 12 months pre-dev

pre_dev <- varieties_prices %>% 
  ungroup() %>% 
  filter(date <= as_date("2002-04-01")) %>% 
  group_by(codigo,VFMARCA,VFESTAB,VFLOCAL) %>%
  summarise(average_price = mean(avg_price, na.rm = T)) %>% 
  ungroup()

pre_dev_indicators <- pre_dev %>% 
  group_by(codigo) %>% 
    mutate( max = max(average_price, na.rm = T),
            min = min(average_price, na.rm = T),
            median = median(average_price, na.rm = T),
            high_p_median = ifelse(average_price >= median, 1, 0),
            n_variety = n(),
            quartile = ntile(average_price,4),
            high_p_quartile = ifelse((n_variety == 2 & quartile == 2) | (n_variety == 3 & quartile == 3) | (n_variety>3 & quartile == 4),1,
                                     ifelse(quartile ==1,0,NA))
            ) %>% 
  ungroup()

saveRDS(pre_dev_indicators, paste0(essay1_data_processed,"/fipe/cheap_expensive_indicators.rds"))