rm(list = ls())
library(tidyverse)
library(lubridate)
library(here)
library(rbcb)
library(BIS)
library(ecoseries)
source(here::here("codes","essay1_paths.R"))

# Download Series from BCB ------------------------------------------------

get_cpi <- function(cpi_code,base_date,start_date){
  
  x <- get_series(c(cpi=cpi_code)) %>%
    mutate(date=as_date(date)) %>% 
    filter(date>=start_date)  %>% 
    mutate(cpi = cumprod(ifelse(date == start_date,1,1+cpi/100)))
  
  base <- x %>% 
    filter(date == base_date) %>% 
    pull()
  
  cpi <- x %>% 
    mutate(cpi = cpi/base)
  
  return(cpi)
}

ipca <- get_cpi(cpi_code = 433,base_date = "2002-04-01", start_date = "1995-01-01") %>% 
  rename(ipca = cpi)

ipca_T <- get_cpi(cpi_code = 4447,base_date = "2002-04-01", start_date = "1995-01-01") %>% 
  rename(ipca_T = cpi)
  
ipca_NT <- get_cpi(cpi_code = 4448,base_date = "2002-04-01", start_date = "1995-01-01") %>% 
  rename(ipca_NT = cpi)

ipc_fipe <- get_cpi(cpi_code = 193,base_date = "2002-04-01", start_date = "1995-01-01") %>% 
  rename(ipc_fipe = cpi)

ipc_fipe_T <- get_cpi(cpi_code = 7475,base_date = "2002-04-01", start_date = "1995-01-01") %>% 
  rename(ipc_fipe_T = cpi)

ipc_fipe_NT <- get_cpi(cpi_code = 7476,base_date = "2002-04-01", start_date = "1995-01-01") %>% 
  rename(ipc_fipe_NT = cpi)

x_rate_sale <- get_series(c(x_rate_sale=3698)) %>%
  mutate(date=as_date(date))

x_rate_purchase <- get_series(c(x_rate_purchase=3697)) %>%
  mutate(date=as_date(date))

# Download Series from BIS ---------

datasets <- get_datasets()

x_rate_dataset <- datasets %>% 
  filter(name == "Effective exchange rate indices (monthly)") %>% 
  select(url) %>% 
  pull()

x_rate <- get_bis(x_rate_dataset,quiet = TRUE) %>% 
  filter(ref_area == "BR", eer_type == "N") %>% 
  mutate(date = as_date(parse_date_time(date,"y%-%m")),
         x_rate_trade = 1/obs_value) 

x_rate_base <- x_rate %>% 
  filter(date == "2002-04-01") %>% 
  pull(x_rate_trade)

x_rate <- x_rate %>% 
  mutate(x_rate_trade = x_rate_trade/x_rate_base) %>% 
  filter(date>="1995-01-01") %>% 
  select(date,x_rate_trade)

# Download Series from Ipeadata -----

ipi_funcex <- as.data.frame(series_ipeadata(35584, periodicity = "M")) 

ipi_funcex <- ipi_funcex %>% 
  mutate(date = as_date(serie_35584.data),
         ipi = serie_35584.valor) %>% 
  filter(date>="1995-01-01") %>% 
  select_at(vars(-matches("serie")))

ipi <- left_join(ipi_funcex,x_rate_purchase,by=c("date")) %>%
  left_join(x_rate_sale, by=c("date")) %>%
  mutate(x_rate_avg = (x_rate_purchase+x_rate_sale)/2,
         ipi = x_rate_avg*ipi)

# rebase IPI
base_ipi <- ipi %>% 
  filter(date == "2002-04-01") %>% 
  pull(ipi)

ipi <- ipi %>% 
  mutate(ipi = ipi/base_ipi)

# Create Data Frame and Save -------------------------------------------------------------------

macro_data <- left_join(ipca,ipca_T,by="date") %>%
  left_join(ipca_NT,by="date") %>%
  left_join(ipc_fipe,by="date") %>%
  left_join(ipc_fipe_NT,by="date") %>%
  left_join(ipc_fipe_T,by="date") %>%
  left_join(ipi,by="date") %>% 
  left_join(x_rate,by="date")


# Save RData
saveRDS(macro_data, file = paste0(essay1_data_raw,"/macro_data.rds"))

     