rm(list = ls())
library(tidyverse)
library(readxl)
library(here)
source(here("codes","essay1_paths.R"))

# Download and Read Classifications from IPEA TD  2056----------------------------------

td2056_url <- "http://www.ipea.gov.br/portal/images/stories/PDFs/TDs/td_2056_apendice.xlsx"
if(.Platform$OS.type=="windows"){
  download.file(td2056_url,paste0(essay1_data_raw,"/td2056_appendix.xlsx"),method="curl")
} else {
  download.file(td2056_url,paste0(essay1_data_raw,"/td2056_appendix.xlsx"))
}

# Read IPCA Official Classifications --------------------------------------


rev1999_2006 <- read_excel(paste0(essay1_data_raw,"/td2056_appendix.xlsx"),
                           sheet = "99_06_11",
                           range = "E7:G599",
                           col_names = c("unique_class","official_class","class_desc"))



rev2006_2011 <- read_excel(paste0(essay1_data_raw,"/td2056_appendix.xlsx"),
                           sheet = "99_06_11",
                           range = "M7:O471",
                           col_names = c("unique_class","official_class","class_desc"))

# Read other BCB Classifications ------------------------------------------

# The BCB provides three classifications: 
#   
# - *cnca* which distinguishes IPCA subitems price indexes in tradables, non-tradables and regulated;
# 
# - *dnds* which distinguishes IPCA subitems price indexes in durables, semi-durables, non-durables, services and regulated;
# 
# - *aism* which distinguishes IPCA subitems price indexes in food and beverages, industrial goods, services and regulated prices.

bcb_class_rev1999_2006 <- read_excel(paste0(essay1_data_raw,"/td2056_appendix.xlsx"),
                                       sheet = "99_06_11",
                                       range = "A7:C599",
                                       col_names = c("cnca","dnds","aism"))


bcb_class_rev2006_2011 <- read_excel(paste0(essay1_data_raw,"/td2056_appendix.xlsx"),
                                       sheet = "99_06_11",
                                       range = "I7:K471",
                                       col_names = c("cnca","dnds","aism"))


# Merge Classifications and Save ------------------------------------------

ipca_classifications_rev1999_2006 <- bind_cols(rev1999_2006,
                                               bcb_class_rev1999_2006) %>% 
  mutate(cnca=factor(cnca,
                       levels=c("0","c","nc","m"),
                       labels=c("NA","Tradables","Non-Tradables","Regulated")),
         dnds=factor(dnds,
                       levels=c("0","nd","sd","d","s","m"),
                       labels=c("NA","Non-Durable Goods","Semi-Durable Goods","Durable Goods","Services","Regulated")),
         aism=factor(aism,
                       levels=c("0","a","i","s","m"),
                       labels=c("NA","Food and Beverages","Industrialized","Services","Regulated")))

ipca_classifications_rev2006_2011 <- bind_cols(rev2006_2011,
                                               bcb_class_rev2006_2011) %>% 
  mutate(cnca=factor(cnca,
                     levels=c("0","c","nc","m"),
                     labels=c("NA","Tradables","Non-Tradables","Regulated")),
         dnds=factor(dnds,
                     levels=c("0","nd","sd","d","s","m"),
                     labels=c("NA","Non-Durable Goods","Semi-Durable Goods","Durable Goods","Services","Regulated")),
         aism=factor(aism,
                     levels=c("0","a","i","s","m"),
                     labels=c("NA","Food and Beverages","Industrialized","Services","Regulated")))

# SaveRDS
saveRDS(ipca_classifications_rev1999_2006, 
        paste0(essay1_data_raw,"/ipca_classifications_rev1999_2006.rds"))
        
saveRDS(ipca_classifications_rev2006_2011, 
        paste0(essay1_data_raw,"/ipca_classifications_rev2006_2011.rds"))        
