rm(list = ls())
library(tidyverse)
library(lubridate)
library(here)
source(here::here("codes","essay1_paths.R"))

start <- as_date("2002-04-01")
end <- as_date("2004-04-01")

macro_data <- readRDS(paste0(essay1_data_raw,"/macro_data.rds")) %>% 
  filter(between(date,start,end)) %>% 
  select(ipca_T,ipca_NT,ipc_fipe_T,ipc_fipe_NT,date) %>% 
  gather(key=variables,value = index,-date) %>% 
  mutate(source = ifelse(str_detect(variables,"ipca"),"IPCA-IBGE","IPC-FIPE"))

# Define x-axis, colors and lines

x_axis <- c(seq(from=start, to=end, by="3 month"))


# Create Plot
plot_ipca_vs_ipcfipe <- ggplot(macro_data, aes(x= date,
                                       y = index,
                                       group = variables,
                                       linetype = source))+
  geom_line()+
  annotate("text", x = as.Date("2003-07-01"), y = 1.23,
           label = "Tradables",color = "black") +
  annotate("text", x = as.Date("2003-07-01"), y = 1.08,
           label = "Non Tradables",color = "black") +
  scale_x_date(breaks=x_axis,date_labels="%b %Y") +
  ylim(1,1.4) +
  theme_classic() +
  theme(legend.position = "bottom",
        legend.title = element_blank(),
        axis.title.x = element_blank(),
        axis.title.y = element_blank(),
        axis.text.x = element_text(size=8),
        axis.text.y = element_text(size=8))

saveRDS(plot_ipca_vs_ipcfipe,paste0(essay1_results,"/plot_ipca_vs_ipcfipe.rds"))