rm(list = ls())
library(tidyverse)
library(lubridate)
library(here)
source(here::here("codes","essay1_paths.R"))


# Plot Time Series Across by decile -------

# Read data -----
across_7d_ibge <- readRDS(paste0(essay1_results,"/across_7dibge_2002_weights.rds")) %>% 
  mutate(digits = 7)

across_7d_fipe <- readRDS(paste0(essay1_results,"/across_7dfipe_1998_weights.rds")) %>% 
  mutate(digits = 7) 


# Prepare Plot -----

across_plot_data <- bind_rows(across_7d_ibge,across_7d_fipe) %>% 
  filter(between(date,as_date("2001-10-01"),as_date("2004-04-01"))) %>% 
  select(-across_dec11)  %>% 
  gather(key="Deciles",value="across",-date,-region,-digits,-ratio_10_90) %>%  
  mutate(Deciles = factor(str_extract(Deciles,pattern = "[0-9]+")),
         Deciles = fct_relevel(Deciles,"10",after = Inf),
         variable_f = factor(paste0(region,": ",digits," digits")),
         variable_f = fct_relevel(variable_f,
                                  "Brazil: 7 digits",
                                  "SP City: 7 digits"))

# Define x axis labels

break_vec <- c(seq(from=as.Date("2001-10-01"), to=as.Date("2004-04-01"), by="3 month"))

# Create data.frame for each region
across_plot_data_br <- across_plot_data %>% 
  filter(region == "Brazil")

across_plot_data_sp <- across_plot_data %>% 
  filter(region == "SP City")

# Create plots -----------

for(i in c("br","sp")){
  
  x <- get(paste0("across_plot_data_",i))
  
  across_plot <- ggplot(x,
                        aes(x=date,
                            y=across,
                            color=Deciles,
                            linetype=Deciles,
                            group=Deciles)) +
    geom_line()+
    geom_vline(xintercept = as_date("2002-04-01"), linetype = "dashed")+
    scale_colour_grey() +
    scale_x_date(breaks=break_vec,date_labels="%b %y") +
    scale_linetype_manual(values = c(1,2,3,4,5,5,4,3,2,1)) +
    guides(color = guide_legend(nrow = 1), linetype = guide_legend(nrow = 1)) +
    theme_classic() +
    theme(legend.position = c(0.65,.1),
          legend.text=element_text(size=7),
          legend.title=element_text(size = 7, hjust = 1),
          legend.background=element_blank(),
          panel.grid.minor.x = element_blank(),
          panel.grid.minor.y = element_blank(),
          axis.title.x = element_blank(),
          axis.title.y = element_blank(),
          panel.grid = element_blank(),
          axis.text.x = element_text(size = 6,hjust = 1))
  
  saveRDS(across_plot,paste0(essay1_results,"/plot_across_",i,".rds"))
  
}
