rm(list = ls())
library(tidyverse)
library(lubridate)
library(here)
library(nprobust)
source(here::here("codes","essay1_paths.R"))

# Plot Across by household income -------

# Read data -----
across_7d_ibge_household <- readRDS(paste0(essay1_results,"/across_7dibge_household_2002_weights.rds"))

across_7d_fipe_household <- readRDS(paste0(essay1_results,"/across_7dfipe_household_1998_weights.rds"))

# Quartic Plots ------

for (j in c("ibge","fipe")){
  x <- get(paste0("across_7d_",j,"_household"))
  
  y <- ggplot(x, aes(x = ln_inc, y = across_pindex)) +
    stat_smooth(method = "lm", formula = y~poly(x,2),size=1,colour = "black") +
    labs(x="ln(income)",
         y="Across Price Index") +
    scale_x_continuous(breaks = seq(2,12,2)) +
    theme_classic() +
    theme(legend.position="none",
          legend.title=element_blank(),
          panel.grid.minor.x = element_blank(),
          panel.grid.minor.y = element_blank(),
          plot.title = element_text(hjust=0.5,margin = margin(t=20)))
  
  saveRDS(y,paste0(essay1_results,"/quartic_plot_",j,".rds"))
}

# Non-parametric Plots ------

for (j in c("ibge","fipe")){
  x <- get(paste0("across_7d_",j,"_household"))
  
  model <- lprobust(x = x$ln_inc, y = x$across_pindex, bwcheck = 30)
  
  y <- nprobust.plot(model,type="line",lwd=1,lcol="black",CIshade=0.4, CIcol="grey60") +
    scale_x_continuous(breaks = seq(2,12,2)) +
    theme_classic() +
    labs(x="ln(income)",y="Across Price Index") +
    theme(legend.position = "none",
          panel.grid.minor.x = element_blank(),
          panel.grid.minor.y = element_blank(),
          panel.grid = element_blank(),
          plot.title = element_text(hjust=0.5,margin = margin(t=20)))
  
  saveRDS(y,paste0(essay1_results,"/nonparametric_plot_",j,".rds"))
}
