rm(list = ls())
library(tidyverse)
library(here)
source(here::here("codes","essay1_paths.R"))

# Read weights
weights <- readRDS(paste0(essay1_data_processed,"/ibge/weights2002_ibge_1d_decile_TvsNT.rds"))

weights_TvsNT <- weights %>%  
  filter(cnca!="Regulated") %>% 
  filter(decile != 11)

plot_engle <- ggplot(weights_TvsNT,
                     aes(
                       x = decile,
                       y = weight,
                       shape = cnca
                     )) +
  geom_line() +
  geom_point(size=3,fill="white") + 
  scale_color_manual(values=c("black"))+
  scale_shape_manual(values=c(21,22))+
  scale_x_continuous("Deciles",breaks=c(seq(1,10))) +
  guides(col = guide_legend(nrow = 2))+
  theme_classic() +
  theme(legend.position = c(0.87,0.95),
        legend.background = element_blank(),
        legend.title = element_blank(),
        axis.title.y = element_blank())

saveRDS(plot_engle,paste0(essay1_results,"/plot_engle_br.rds"))