rm(list = ls())
library(tidyverse)
library(lubridate)
library(here)
source(here::here("codes","essay1_paths.R"))

start <- as_date("2002-04-01")
end <- as_date("2004-04-01")

macro_data <- readRDS(paste0(essay1_data_raw,"/macro_data.rds")) %>% 
  filter(between(date,start,end)) %>% 
  select(ipca_T,ipca_NT,ipi,x_rate_trade,date) %>% 
  gather(key=variables,value = index,-date) 

# Define x-axis, colors and lines

x_axis <- c(seq(from=start, to=end, by="3 month"))


my_lines <- c("dotted","dashed","longdash","solid")

# Create Plot
plot_dev2002 <- ggplot(macro_data, aes(x= date,
                         y = index,
                         group = variables,
                         linetype = variables))+
  geom_line()+
  annotate("text", x = as.Date("2002-12-01"), y = 1.5,
           label = " Exchange Rate",color = "black") +
  annotate("text", x = as.Date("2003-01-01"), y = 1.77,
           label = "Tradables at the Dock",color = "black") +
  annotate("text", x = as.Date("2003-07-01"), y = 1.23,
           label = "Tradables",color = "black") +
  annotate("text", x = as.Date("2003-07-01"), y = 1.08,
           label = "Non Tradables",color = "black") +
  scale_linetype_manual(values = my_lines)+
  scale_x_date(breaks=x_axis,date_labels="%b %Y") +
  ylim(1,1.8) +
  theme_classic() +
  theme(legend.position = "none",
        axis.title.x = element_blank(),
        axis.title.y = element_blank(),
        axis.text.x = element_text(size=8),
        axis.text.y = element_text(size=8))

saveRDS(plot_dev2002,paste0(essay1_results,"/plot_dev2002.rds"))