rm(list = ls())
library(tidyverse)
library(here)
source(here::here("codes","essay1_paths.R"))

# Read data -----

cpi_ibge <- readRDS(paste0(essay1_data_processed,"/ibge/cpi_br.rds")) 

weights_1d <- readRDS(paste0(essay1_data_processed,"/ibge/weights2008_ibge_1d_decile.rds"))

weights_7d <- readRDS(paste0(essay1_data_processed,"/ibge/weights2008_ibge_7d_decile.rds"))

weights_household <- readRDS(paste0(essay1_data_processed,"/ibge/weights2008_ibge_7d_household.rds"))

pof <- readRDS(paste0(essay1_data_processed,"/ibge/pof2008_with_ipca_codes.rds"))

# Estimate Across 1 d ------------

cpi_1d <- cpi_ibge %>% 
  filter(level == 1, ipca!="0") %>% 
  select(ipca,ipca_desc,date,cpi) %>% 
  mutate(ipca_group = as.numeric(ipca))

# Merge CPI and weights and compute across
across_1d <- weights_1d %>% 
  left_join(cpi_1d, by = c("ipca_group")) %>% 
  mutate(weighted_cpi = weight*cpi) %>% 
  group_by(date,decile) %>% 
  summarise(weighted_cpi = sum(weighted_cpi, na.rm = T)) %>% 
  spread(key = "decile", value = "weighted_cpi") %>% 
  ungroup() %>% 
  rename_at(vars(-date),funs(paste0("across_dec",.))) %>%
  mutate(region = "Brazil",
         ratio_10_90 = (across_dec1-1)/(across_dec10-1),
         ratio_10_90 = ifelse((is.nan(ratio_10_90)|is.infinite(ratio_10_90)),NA,ratio_10_90)) %>% 
  bind_rows()

# Estimate Across 7d ------------

cpi_7d <- cpi_ibge %>% 
  filter(level == 7) %>% 
  select(ipca,ipca_desc,date,cpi) %>% 
  mutate(ipca = as.numeric(ipca))

# Merge CPI and weights and compute across
across_7d <- weights_7d %>% 
  left_join(cpi_7d, by = c("ipca")) %>% 
  mutate(weighted_cpi = weight*cpi) %>% 
  group_by(date,decile) %>% 
  summarise(weighted_cpi = sum(weighted_cpi, na.rm = T)) %>% 
  spread(key = "decile", value = "weighted_cpi") %>% 
  ungroup() %>% 
  rename_at(vars(-date),funs(paste0("across_dec",.))) %>% 
  mutate(region = "Brazil",
         ratio_10_90 = (across_dec1-1)/(across_dec10-1),
         ratio_10_90 = ifelse((is.nan(ratio_10_90)|is.infinite(ratio_10_90)),NA,ratio_10_90)) %>% 
  bind_rows()
  

# Estimate Across by 7d Household ---------------

# Obtain Incomes 

income_ibge <- pof %>% 
  distinct(uckey,renda_mensal_uc)  

# Merge inflation and weights and compute weighted inflation by household
cpi_end <- cpi_7d %>%
  filter(date == "2004-04-01")

across_7d_household <- weights_household %>% 
  left_join(cpi_end, by = c("ipca")) %>% 
  mutate(weighted_cpi = weight*cpi) %>% 
  group_by(date, uckey) %>% 
  summarise(across_pindex = sum(weighted_cpi, na.rm = T)) %>% 
  ungroup() %>% 
  inner_join(income_ibge,by="uckey") %>% 
  mutate(ln_inc=log(renda_mensal_uc)) 

# Save -------
saveRDS(across_1d,paste0(essay1_results,"/across_1dibge_2008_weights.rds"))
saveRDS(across_7d,paste0(essay1_results,"/across_7dibge_2008_weights.rds"))
saveRDS(across_7d_household,paste0(essay1_results,"/across_7dibge_household_2008_weights.rds"))


