rm(list = ls())
library(tidyverse)
library(here)
source(here::here("codes","essay1_paths.R"))

# Read data -----
regional_weights_7d <- readRDS(paste0(essay1_data_processed,"/ibge/regional_weights2002_ibge_7d_decile.rds")) 
  
#regions <- c("br","pa","ce","pe","ba","mg","rj","sp","pr","rs")
regions_numeric <- c(15,23,26,29,31,33,35,41,43)

for (j in regions_numeric){
  if (j == 15){
    i <- "pa"
  }
  
  if (j == 23){
    i <- "ce"
  }
  
  if (j == 26){
    i <- "pe"
  }
  
  if (j == 29){
    i <- "ba"
  }
  
  if (j == 31){
    i <- "mg"
  }
  
  if (j == 33){
    i <- "rj"
  }
  
  if (j == 41){
    i <- "pr"
  }
  
  if (j == 43){
    i <- "rs"
  }
  
  if (j == 35){
    i <- "sp"
  }

  weights_7d <- regional_weights_7d %>% 
    filter(region == i)
  
  # Read CPI  
  cpi_ibge <- readRDS(paste0(essay1_data_processed,"/ibge/cpi_",i,".rds"))
  
  ipca <- cpi_ibge %>% 
    filter(ipca == "0") %>% 
    select(date,cpi)
  # Estimate Across 7d ------------
  
  cpi_7d <- cpi_ibge %>% 
    filter(level == 7, !is.na(cpi)) %>% 
    select(ipca,ipca_desc,date,cpi) %>% 
    mutate(ipca = as.numeric(ipca))
  
  # Merge CPI and weights and compute across
  x <- weights_7d %>% 
    left_join(cpi_7d, by = c("ipca")) %>%  
    mutate(weighted_cpi = weight*cpi) %>% 
    group_by(date,decile) %>% 
    summarise(weighted_cpi = sum(weighted_cpi, na.rm = T)) %>% 
    spread(key = "decile", value = "weighted_cpi") %>% 
    ungroup() %>% 
    rename_at(vars(-date),funs(paste0("across_dec",.))) %>% 
    mutate(region = i,
           ratio_10_90 = (across_dec1-1)/(across_dec10-1),
           ratio_10_90 = ifelse((is.nan(ratio_10_90)|is.infinite(ratio_10_90) |near(ratio_10_90,0)),NA,ratio_10_90)) %>% 
    left_join(ipca, by = c("date")) %>% 
    bind_rows()
  
  assign(paste0("across_7d_",i),x)
  
  rm(x)
}

across_7d_region <- mget(apropos("across_")) %>% 
  bind_rows() %>% 
  select(-across_dec11)

# Save -------

saveRDS(across_7d_region,paste0(essay1_results,"/regional_across_7d_ibge_2002_weights.rds"))



