rm(list = ls())
library(tidyverse)
library(broom)
library(here)
library(lfe)
source(here::here("codes","essay1_paths.R"))

pof_fipe <- readRDS(paste0(essay1_data_processed,"/fipe/pof_fipe.rds"))    

# Obtain deciles

deciles_fipe <- pof_fipe %>% 
  distinct(COD_DOM,RENDA) %>% 
  mutate(decile = cut(RENDA,
                      breaks = quantile (RENDA,probs = seq(0,1,by=0.1)),
                      labels = seq_len(10),
                      include.lowest = T,
                      na.rm = T),
         decile = as.numeric(decile)) %>% 
  select(-RENDA)

# Join deciles

pof_fipe <- pof_fipe %>% 
  left_join(deciles_fipe, by = "COD_DOM")
  
pof_fipe <- pof_fipe %>% 
filter(VAL_UNI>0) %>% 
  mutate(decile=factor(decile),
         VAL_UNI=log(VAL_UNI),
         ipc_factor=factor(ipc)) 


# Estimate Model

model_uni_p <- felm(VAL_UNI ~ decile | ipc_factor | 0 | ipc_factor, data = pof_fipe)

saveRDS(model_uni_p,paste0(essay1_results,"/unit_prices_bydecile.rds"))


