rm(list = ls())
library(tidyverse)
library(here)
source(here::here("codes","essay1_paths.R"))


# Read Data --------

pof_fipe <- readRDS(paste0(essay1_data_processed,"/fipe/pof_fipe.rds"))

fipe_ipc <- readRDS(paste0(essay1_data_processed,"/fipe/ipc_fipe.rds")) 

weights_fipe_1d <- readRDS(paste0(essay1_data_processed,"/fipe/weights_fipe_1d_decile.rds"))

weights_fipe_7d <- readRDS(paste0(essay1_data_processed,"/fipe/weights_fipe_7d_decile.rds"))

weights_fipe_7d_household <- readRDS(paste0(essay1_data_processed,"/fipe/weights_fipe_7d_household.rds"))

# Estimate Across 1 d ------------

cpi_1d <- fipe_ipc %>% 
  filter(level == 1, ipc!=0) %>% 
  select(ipc,ipc_desc,date,cpi) %>% 
  mutate(ipc_group = paste0(ipc))

# Merge CPI and weights and compute across
across_1d <- weights_fipe_1d %>% 
  left_join(cpi_1d, by = c("ipc_group")) %>% 
  mutate(weighted_cpi = weight*cpi) %>% 
  group_by(date,decile) %>% 
  summarise(weighted_cpi = sum(weighted_cpi, na.rm = T)) %>% 
  spread(key = "decile", value = "weighted_cpi") %>% 
  ungroup() %>% 
  rename_at(vars(-date),funs(paste0("across_dec",.))) %>% 
  mutate(region = "SP City",
         ratio_10_90 = (across_dec1-1)/(across_dec10-1),
         ratio_10_90 = ifelse((is.nan(ratio_10_90)|is.infinite(ratio_10_90)),NA,ratio_10_90)) %>% 
  bind_rows()

# Estimate Across 7d ------------

cpi_7d <- fipe_ipc %>% 
  filter(level == 6) %>% 
  select(ipc,ipc_desc,date,cpi) 

# Merge CPI and weights and compute across
across_7d <- weights_fipe_7d %>% 
  left_join(cpi_7d, by = c("ipc")) %>% 
  mutate(weighted_cpi = weight*cpi) %>% 
  group_by(date,decile) %>% 
  summarise(weighted_cpi = sum(weighted_cpi, na.rm = T)) %>% 
  spread(key = "decile", value = "weighted_cpi") %>% 
  ungroup() %>% 
  rename_at(vars(-date),funs(paste0("across_dec",.))) %>% 
  mutate(region = "SP City",
         ratio_10_90 = (across_dec1-1)/(across_dec10-1),
         ratio_10_90 = ifelse((is.nan(ratio_10_90)|is.infinite(ratio_10_90)),NA,ratio_10_90)) %>% 
  bind_rows()


# Estimate Across by 7d Household ---------------

# Obtain Incomes 

income_fipe <- pof_fipe %>% 
  distinct(COD_DOM,RENDA)  
  
# Merge inflation and weights and compute weighted inflation by 
cpi_end <- cpi_7d %>%
  filter(date == "2004-04-01")

across_7d_household <- weights_fipe_7d_household %>% 
  left_join(cpi_end, by = c("ipc")) %>% 
  mutate(weighted_cpi = weight*cpi) %>% 
  group_by(date, COD_DOM) %>% 
  summarise(across_pindex = sum(weighted_cpi, na.rm = T)) %>% 
  ungroup() %>% 
  inner_join(income_fipe,by="COD_DOM") %>% 
  mutate(ln_inc=log(RENDA))


# Save -------
saveRDS(across_1d,paste0(essay1_results,"/across_1dfipe_1998_weights.rds"))
saveRDS(across_7d,paste0(essay1_results,"/across_7dfipe_1998_weights.rds"))
saveRDS(across_7d_household,paste0(essay1_results,"/across_7dfipe_household_1998_weights.rds"))

