rm(list = ls())
library(tidyverse)
library(rlang)
library(lubridate)
library(here)
source(here::here("codes","essay1_paths.R"))

# Create ipca price index to inflate from Jun 1999 to Jan 2003 ----

start_ipca <- "1999-06-01"
end_ipca <- "2003-01-01"

macro_data <- readRDS(paste0(essay1_data_raw,"/macro_data.rds"))
ipca <- macro_data %>% 
  select(date,ipca) %>% 
  filter(date >= start_ipca & date <= end_ipca)

ipca_inflate <- ipca %>% 
  mutate(ipca_factor=ifelse(date==start_ipca,1,1+ipca/100),
         ipca_index=cumprod(ipca_factor)) %>% 
  filter(date==end_ipca) %>% 
  select(ipca_index) %>% 
  as.numeric()

# Weights 1 digit

weights_ibge_1d <- readRDS(paste0(essay1_data_processed,"/ibge/weights2002_ibge_1d_decile.rds")) %>% 
  filter(decile!=11) %>% 
  pivot_wider(names_from = decile, values_from = weight) %>% 
  mutate(region = "Brazil") %>% 
  add_column(desc = c("Food and Beverages","Housing",
             "Household Fur. and App.","Apparel","Transportation",
             "Health","Individual Expenses","Education","Communication")) %>% 
  select(region,ipca_group,desc,everything())

weights_fipe_1d <- readRDS(paste0(essay1_data_processed,"/fipe/weights_fipe_1d_decile.rds")) %>% 
  filter(decile!=11) %>% 
  pivot_wider(names_from = decile, values_from = weight) %>% 
  mutate(region = "City of Sao Paulo",
         ipc_group = as.numeric(ipc_group)) %>% 
  add_column(desc = c("Housing",
                           "Food and Beverages", "Transportation",
                           "Individual Expenses","Health",
                           "Apparel","Education")) %>% 
  select(region,ipca_group = ipc_group,desc,everything())

# Average Income

pof_ibge <- readRDS(paste0(essay1_data_processed,"/ibge/pof2002_with_ipca_codes.rds"))

# Obtain deciles

deciles <- pof_ibge %>% 
  distinct(uckey,renda_mensal_uc) %>% 
  mutate(decile = cut(renda_mensal_uc,
                      breaks = quantile (renda_mensal_uc,probs = seq(0,1,by=0.1)),
                      labels = seq_len(10),
                      include.lowest = T,
                      na.rm = T),
         decile = as.numeric(decile)) %>% 
  select(-renda_mensal_uc)

# Join deciles

pof_ibge <- pof_ibge %>% 
  left_join(deciles, by = "uckey")

# compute average income
avg_income_ibge <- pof_ibge %>% 
  group_by(decile) %>% 
  summarise(avg_inc = mean(renda_mensal_uc,na.rm=T)) %>% 
  pivot_wider(names_from = decile, values_from = avg_inc) %>%
  mutate(region = "Brazil") %>% 
  add_column(desc = c("Average Income"),
             ipca_group = NA) %>% 
  select(region,ipca_group,desc,everything())

## FIPE

# Read POF
pof_fipe <- readRDS(paste0(essay1_data_processed,"/fipe/pof_fipe.rds")) %>% 
  distinct(COD_DOM,RENDA)

# Obtain deciles

deciles_fipe <- pof_fipe %>% 
  distinct(COD_DOM,RENDA) %>% 
  mutate(decile = cut(RENDA,
                      breaks = quantile (RENDA,probs = seq(0,1,by=0.1)),
                      labels = seq_len(10),
                      include.lowest = T,
                      na.rm = T),
         decile = as.numeric(decile)) %>% 
  select(-RENDA)

# Join deciles

pof_fipe <- pof_fipe %>% 
  left_join(deciles_fipe, by = "COD_DOM")

# compute average income
avg_income_fipe <- pof_fipe %>% 
  mutate(RENDA = RENDA*ipca_inflate) %>% 
  group_by(decile) %>% 
  summarise(avg_inc = mean(RENDA,na.rm=T)) %>% 
  pivot_wider(names_from = decile, values_from = avg_inc) %>%
  mutate(region = "City of Sao Paulo") %>% 
  add_column(desc = c("Average Income"),
             ipca_group = NA) %>% 
  select(region,ipca_group,desc,everything())

# Joining
inc_share_ibge <- bind_rows(avg_income_ibge,weights_ibge_1d)
inc_share_fipe <- bind_rows(avg_income_fipe,weights_fipe_1d)
# Re-order to be closer to IBGE Group classification
inc_share_fipe <- inc_share_fipe[c(1,3,2,7,4,6,5,8),]

inc_share_tab <- bind_rows(inc_share_ibge,inc_share_fipe)

# SaveRDS ----

saveRDS(inc_share_tab,paste0(essay1_results,"/descriptive_income_share_tab.rds"))
