# The following packages are required to run the codes below
# if you do not have them installed, uncomment the lines below and run them once
# devtools::install_github('wilsonfreitas/rbcb')
# devtools::install_github("lucasmation/microdadosBrasil")
# install.packages(here::here("packages","ecoseries_0.1.5.tar.gz"), repos = NULL, type="source")
# install.packages("tidyverse")
# install.packages("readxl")
# install.packages("here")
# install.packages("BIS")
# install.packages("magrittr")
# install.packages("foreign")
# install.packages("rlang")
# install.packages("nprobust")
# install.packages("lfe")
# install.packages("knitr")
# install.packages("kableExtra")
# install.packages("bookdown")

# Run Scripts to download data -----

# If you want to download the raw data again, uncomment the following lines and run the download scripts.
# If the data was not obtained using a code, we provide a "how to" file in the folder where the raw data is stored

# Download Data ----
# 
# source(here::here("codes","download","download_ipca_classifications.R"))
# source(here::here("codes","download","download_ipca.R"))
# source(here::here("codes","download","download_macrodata.R"))
# source(here::here("codes","download","download_pof.R"))

# Run scripts that process raw data  -----

# Process IBGE Data
source(here::here("codes","process","ibge","create_ipca_price_indices.R"))
source(here::here("codes","process","ibge","create_pof2002_with_ipca_codes.R"))
source(here::here("codes","process","ibge","create_weights_pof_2002.R"))
source(here::here("codes","process","ibge","create_weights_pof_2002_regions.R"))
source(here::here("codes","process","ibge","create_pof2008_with_ipca_codes.R")) 
source(here::here("codes","process","ibge","create_weights_pof_2008.R"))

# Process FIPE Data
source(here::here("codes","process","fipe","create_fipe_correspondences.R"))
source(here::here("codes","process","fipe","create_ipcfipe.R"))
source(here::here("codes","process","fipe","create_pof_fipe.R"))
source(here::here("codes","process","fipe","create_weights_fipe.R"))
source(here::here("codes","process","fipe","create_varieties_prices.R"))
source(here::here("codes","process","fipe","create_cheap_expensive_indicator.R"))
source(here::here("codes","process","fipe","create_varieties_prices_complete.R"))
source(here::here("codes","process","fipe","create_cheap_expensive_indicator_complete.R"))

# Run scripts that produces figures and tables  -----

# Figure 1 - Panel A
source(here::here("codes","analyze","ibge","plot_dev2002.R"))

# Figure 1 - Panel B
source(here::here("codes","analyze","ibge","plot_engle.R"))

# Table 1
source(here::here("codes","analyze","ibge","across_ibge_2002_weights.R"))
source(here::here("codes","analyze","fipe","across_fipe.R"))

# Table 2 and Figure D.3
source(here::here("codes","analyze","fipe","within_changes_complete.R"))

# Table 3 and Figure D.4
source(here::here("codes","analyze","fipe","combined_complete.R"))

# Figure A.1
source(here::here("codes","analyze","plot_ipca_vs_ipcfipe.R"))

# Table B.1
source(here::here("codes","analyze","descriptive_income_shares.R"))

# Table C.1
source(here::here("codes","analyze","fipe","unit_prices_reg.R"))

# Figure D.1
source(here::here("codes","analyze","plot_across_timeseries.R"))

# Figure D.2
source(here::here("codes","analyze","plot_across_household.R"))

# Table E.1
source(here::here("codes","analyze","ibge","across_ibge_2002_weights_byregion.R"))

# Table E.2
source(here::here("codes","analyze","ibge","across_ibge_2008_weights.R"))

# Table F.1 and Figure F.1
source(here::here("codes","analyze","fipe","within_changes.R"))

# Table F.2 and Figure F.2
source(here::here("codes","analyze","fipe","combined.R"))

# Generate formatted tables and figures
rmarkdown::render(here::here("figures_and_tables","figures_and_tables.Rmd"))
rmarkdown::render(here::here("figures_and_tables","online_appendix.Rmd"))


