# Plot examples prices with their HP trend

source("functions.R")
library(R.matlab)
library(reshape2)
library(ggplot2)

# Data
## Import data from Matlab

HP <- readMat("../Results/HPCom.mat")$Prices

Year <- 1900:2011

for(icom in 1:13) {
    Prices <- data.frame(Price = HP[2,1,icom],
                         HPTrend = HP[4,1,icom],
                         Year = Year,
                         Commodity = HP[1,1,icom])
    if(icom == 1) AllPrices <- Prices
    else AllPrices <- rbind(AllPrices,Prices)
}


AllPrices           <- melt(AllPrices,id.vars=c("Year","commodity"),
                            variable.name = "Trend")

levels(AllPrices$Trend) <- c("Real price","HPTrend")

PlotAllPrices <- function() {
    ggplot(subset(AllPrices,commodity %in% c("Copper","Cotton","Rice")),
           aes(x = Year, y = value,colour = Trend)) +
    geom_line(size = 1,aes(linetype=Trend)) +
    facet_wrap(~commodity,ncol=3) +
    theme_bw() +
    ylab("Real price") +
    scale_colour_manual(values = c("black","red")) +
    guides(colour = guide_legend(title = NULL), linetype = guide_legend(title = NULL)) +
    theme(legend.position = "none", legend.key = element_blank(), text = element_text(size = 20))
}
PlotAllPrices()

ggsave(filename = "../Figures/Times/HPPrices.pdf",
       plot = PlotAllPrices(),
       units = "in",
       width = 12,
       height = 6,
       pointsize = 9,
       family = "Times")
