# Plot the first-order correlation as a function of storage cost and
# demand elasticity

source("functions.R")

library(R.matlab)

Corstat<-readMat('../Results/SimulatedAutocorr.mat')

Corstatk<-Corstat$Qcorstatk
Corstatb<-Corstat$Qcorstatb

# Xaxis (storage costs and demand elasticities)
StoCost<-Corstat$StoCost
eta<-Corstat$eta

AR1k<-Corstatk[,1,]
AR1b<-Corstatb[,1,]

ARStorage <- function() {
    par(las = 1,
        mar = c(4.1,3.7,0.5,0.8))
    matplot(StoCost,
            AR1k,
            xlab='Storage cost',
            ylab='1st order autocorrelation',
            type='l',
            lty= c(2,1,3),
            col = c("blue","black","blue"),
            xaxs = "i",
            yaxs = "i",
            ylim = c(0, 1),
            cex.axis=0.75,
            cex.lab=0.75)
    legend("topright",
           legend = c("95th percentile","50th percentile","5th percentile"),
           lty=c(3,1,2),
           bty = "n",
           col = c("blue","black","blue"),
           pt.cex = 1,
           cex = 0.8)
}
ARStorage()

ARElasticity <- function() {
    par(las = 1,
        mar = c(4.1,0.8,0.5,3.7))
    matplot(eta,
            AR1b,
            xlab='Demand elasticity',
            ylab='1st Order autocorrelation',
            type='l',
            lty=c(2,1,3),
            xaxs = "i",
            yaxs = "i",
            yaxt = "n",
            col = c("blue","black","blue"),
            ylim = c(0, 1),
            cex.axis=0.75,
            cex.lab=0.75)
}
ARElasticity()

FiguresCreation(file = c("../Figures/","ARStorage"),
                quote(ARStorage),
                width=3,height=2.5,pointsize=10)

FiguresCreation(file = c("../Figures/","ARElasticity"),
                quote(ARElasticity),
                width=3,height=2.5,pointsize=10)
