'------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
'This program produces global inflation forecasts based on an augmented AO model: grid search over weight on global inflation
'Authors: Christian Gillitzer and Martin McCarthy, January 2019
'------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Setup quarterly workfile
workfile q 1960:1 2019:2
smpl @all

mode quiet

cd "C:\Users\cgil3035\Dropbox (sydney uni)\Global Inflation\JAE.R2\Code"

'Load Headline CPI index levels
smpl @first @last
read(b2,s=CM_Extended_sa) "..\Data\Data.xls" 23

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Transform variables
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Calculate inflation rates: annualised
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

	series l{%country} = @log({%country})

	for !h=1 to 8 'h-period average inflation
		
		series d{!h}l{%country} = (400/{!h})*(l{%country} - l{%country}(-{!h}))

	next

next

'Group inflation rates
group d4lcpi_global d4lcpi_aut d4lcpi_bel d4lcpi_fin d4lcpi_fra d4lcpi_ger d4lcpi_ita d4lcpi_ned d4lcpi_por d4lcpi_esp d4lcpi_irl d4lcpi_den d4lcpi_gre d4lcpi_swe d4lcpi_uk d4lcpi_nor d4lcpi_sui d4lcpi_can d4lcpi_jpn d4lcpi_usa d4lcpi_aus d4lcpi_nzl d4lcpi_lux d4lcpi_u2
group d1lcpi_global d1lcpi_aut d1lcpi_bel d1lcpi_fin d1lcpi_fra d1lcpi_ger d1lcpi_ita d1lcpi_ned d1lcpi_por d1lcpi_esp d1lcpi_irl d1lcpi_den d1lcpi_gre d1lcpi_swe d1lcpi_uk d1lcpi_nor d1lcpi_sui d1lcpi_can d1lcpi_jpn d1lcpi_usa d1lcpi_aus d1lcpi_nzl d1lcpi_lux d1lcpi_u2

'G7 mean inflation
group d1lcpi_G7 d1lcpi_can d1lcpi_fra d1lcpi_ger d1lcpi_ita d1lcpi_jpn d1lcpi_uk d1lcpi_usa
series d1lcpi_G7_avg = @rmean(d1lcpi_G7)

'All country mean inflation
series d1lcpi_global_avg = @rmean(d1lcpi_global)
series d4lcpi_global_avg = @rmean(d4lcpi_global)

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' RMSE of AO-Global model forecast relative to AO model by weight on global inflation: 4q horizon
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
!h=4 '4q horizon

'Table to store results
table(24,102) rmse_AOgrid_4q
rmse_AOgrid_4q(1,1) = "weight"

'Grid search over weights on global inflation
scalar counter = 1 'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
	
	scalar counter = counter + 1
	rmse_AOgrid_4q(counter,1) = %country

	!h_minus = -!h 'Forecast horizon

     smpl 1995:4+{!h} 2016:4

	'AO model forecast
	series fcst_AO_{%country}_h{!h} = d4l{%country}(!h_minus) 'AO forecasts
     series sq_error_AO_{%country}_h{!h} = (d4l{%country} - fcst_AO_{%country}_h{!h})^2 'Squared AO model forecast errors	

	for !w=0 to 100 'Loop over weight on global inflation

		rmse_AOgrid_4q(1,{!w}+2) = {!w}/100

		series fcst_AOgl_{%country}_h{!h}_w{!w} = na	 'Series to store AO-global forecasts
		series sq_error_AOgl_{%country}_h{!h}_w{!w} = na 'Series to store squared AO-global forecast errors

		scalar weight = !w/100		

		fcst_AOgl_{%country}_h{!h}_w{!w} = (1-weight)*d4l{%country}(!h_minus) + weight*d4lcpi_global_avg(!h_minus)  	'Store forecasts
       	sq_error_AOgl_{%country}_h{!h}_w{!w} = (d4l{%country} - fcst_AOgl_{%country}_h{!h}_w{!w})^2	 'Squared forecast error																				

		rmse_AOgrid_4q(counter,{!w}+2)  = @sqrt(@mean(sq_error_AOgl_{%country}_h{!h}_w{!w})) / @sqrt(@mean(sq_error_AO_{%country}_h{!h}))
					
	next

next

'Export results
rmse_AOgrid_4q.save(t=csv) "rmse_ratio_AOgrid_4q.csv"

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' RMSE of AO-Global model forecast relative to AO model by weight on global inflation: 8q horizon
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
!h=8 '8q horizon

'Table to store results
table(24,102) rmse_AOgrid_8q
rmse_AOgrid_8q(1,1) = "weight"

'Grid search over weights on global inflation
scalar counter = 1 'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
	
	scalar counter = counter + 1
	rmse_AOgrid_8q(counter,1) = %country

	!h_minus = -!h 'Forecast horizon

     smpl 1995:4+{!h} 2016:4

	'AO model forecast
	series fcst_AO_{%country}_h{!h} = d4l{%country}(!h_minus) 'AO forecasts
     series sq_error_AO_{%country}_h{!h} = (d8l{%country} - fcst_AO_{%country}_h{!h})^2 'Squared AO model forecast errors	

	for !w=0 to 100 'Loop over weight on global inflation

		rmse_AOgrid_8q(1,{!w}+2) = {!w}/100

		series fcst_AOgl_{%country}_h{!h}_w{!w} = na	 'Series to store AO-global forecasts
		series sq_error_AOgl_{%country}_h{!h}_w{!w} = na 'Series to store squared AO-global forecast errors

		scalar weight = !w/100		

		fcst_AOgl_{%country}_h{!h}_w{!w} = (1-weight)*d4l{%country}(!h_minus) + weight*d4lcpi_global_avg(!h_minus)  	'Store forecasts
       	sq_error_AOgl_{%country}_h{!h}_w{!w} = (d8l{%country} - fcst_AOgl_{%country}_h{!h}_w{!w})^2	 'Squared forecast error																				

		rmse_AOgrid_8q(counter,{!w}+2)  = @sqrt(@mean(sq_error_AOgl_{%country}_h{!h}_w{!w})) / @sqrt(@mean(sq_error_AO_{%country}_h{!h}))
					
	next

next

'Export results
rmse_AOgrid_8q.save(t=csv) "rmse_ratio_AOgrid_8q.csv"
