'------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
'This program produces global inflation forecasts based on an augmented AO model
'Authors: Christian Gillitzer and Martin McCarthy, May 2018
'------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Setup quarterly workfile
workfile q 1960:1 2019:2
smpl @all

mode quiet

cd "C:\Users\cgil3035\Dropbox\Global Inflation\JAE.R1\Code"

scalar maxh=8	'Maximum forecast horizon
scalar T = 230+maxh		'Number of observations in dataset + forecast horizon
scalar T0 = @dtoo("1960:1")-1	'First data in estimation window
scalar length = @dtoo("1985:1")-maxh-T0	'Initial estimation window length (quarters)
scalar window = 60 'Rolling estimation window

'Load Headline CPI index levels
smpl @first @last
read(b2,s=CM_Extended_sa) "..\Data\Data.xls" 23

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Transform variables
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Calculate annualised inflation rates: annualised
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

	series l{%country} = @log({%country})

	for !h=1 to 8 'h-period average inflation
		
		series d{!h}l{%country} = (400/{!h})*(l{%country} - l{%country}(-{!h}))

	next

next

'Group inflation rates
group d4lcpi_global d4lcpi_aut d4lcpi_bel d4lcpi_fin d4lcpi_fra d4lcpi_ger d4lcpi_ita d4lcpi_ned d4lcpi_por d4lcpi_esp d4lcpi_irl d4lcpi_den d4lcpi_gre d4lcpi_swe d4lcpi_uk d4lcpi_nor d4lcpi_sui d4lcpi_can d4lcpi_jpn d4lcpi_usa d4lcpi_aus d4lcpi_nzl d4lcpi_lux d4lcpi_u2
group d1lcpi_global d1lcpi_aut d1lcpi_bel d1lcpi_fin d1lcpi_fra d1lcpi_ger d1lcpi_ita d1lcpi_ned d1lcpi_por d1lcpi_esp d1lcpi_irl d1lcpi_den d1lcpi_gre d1lcpi_swe d1lcpi_uk d1lcpi_nor d1lcpi_sui d1lcpi_can d1lcpi_jpn d1lcpi_usa d1lcpi_aus d1lcpi_nzl d1lcpi_lux d1lcpi_u2

'G7 mean inflation
group d1lcpi_G7 d1lcpi_can d1lcpi_fra d1lcpi_ger d1lcpi_ita d1lcpi_jpn d1lcpi_uk d1lcpi_usa
series d1lcpi_G7_avg = @rmean(d1lcpi_G7)

'All country mean inflation
series d1lcpi_global_avg = @rmean(d1lcpi_global)
series d4lcpi_global_avg = @rmean(d4lcpi_global)

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' AO model forecast
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results
table(24,9) rmse_AO
rmse_AO(1,2) = "1q"
rmse_AO(1,3) = "2q"
rmse_AO(1,4) = "3q"
rmse_AO(1,5) = "4q"
rmse_AO(1,6) = "5q"
rmse_AO(1,7) = "6q"
rmse_AO(1,8) = "7q"
rmse_AO(1,9) = "8q"

'Estimate forecasting regressions
scalar counter = 1 'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
	
	scalar counter = counter + 1
	rmse_AO(counter,1) = %country
	
	for !h=1 to maxh	'Loop over forecast horizons

		series fcst_AO_{%country}_h{!h} = na	 'Series to store forecasts
		series sq_error_AO_{%country}_h{!h} = na 'Series to store squared forecast errors

		for !t = 0 to (T-T0-length-maxh)	'Loop over time periods

			smpl @first+T0+(length-1)+!t+!h @first+T0+(length-1)+!t+!h
			!h_minus = -!h
			fcst_AO_{%country}_h{!h} = d4l{%country}(!h_minus)	'Store forecasts
			scalar actual = @elem(d{!h}l{%country},@otod(1+T0+(length-1)+{!t}+{!h})) 'Actual outcome													
			sq_error_AO_{%country}_h{!h} = (actual - d4l{%country}(!h_minus))^2	 'Squared forecast error																										

		next		

		smpl 1995:4+{!h} 2016:4
		rmse_AO(counter,{!h}+1) = @sqrt(@mean(sq_error_AO_{%country}_h{!h}))

	next
 
next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Forecasts: AO model augmented with global factor
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results
table(24,9) rmse_gl
rmse_gl(1,2) = "1q"
rmse_gl(1,3) = "2q"
rmse_gl(1,4) = "3q"
rmse_gl(1,5) = "4q"
rmse_gl(1,6) = "5q"
rmse_gl(1,7) = "6q"
rmse_gl(1,8) = "7q"
rmse_gl(1,9) = "8q"

'Estimate forecasting regressions
scalar counter = 1 'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
	
	scalar counter = counter + 1
	rmse_gl(counter,1) = %country
	
	for !h=1 to maxh	'Loop over forecast horizons

		series fcst_gl_{%country}_h{!h} = na	 'Series to store forecasts
		series sq_error_gl_{%country}_h{!h} = na 'Series to store squared forecast errors

		for !t = 0 to (T-T0-length-maxh)	'Loop over time periods

			smpl @first+T0 @first+T0+(length-1)+!t
			!h_minus = -!h
			!h_minus1 = -!h-1
			!h_minus2 = -!h-2
			!h_minus3 = -!h-3
			'equation reg_gl_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}l{%country} - d4l{%country}(!h_minus) = c(1)*((1/4)*(d1lcpi_global_avg(!h_minus) + d1lcpi_global_avg(!h_minus1) + d1lcpi_global_avg(!h_minus2) + d1lcpi_global_avg(!h_minus3)) - d4l{%country}(!h_minus)) 	'In-sample forecasting regression	
			equation reg_gl_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}l{%country} - d4l{%country}(!h_minus) = c(1)*(d4lcpi_global_avg(!h_minus) - d4l{%country}(!h_minus)) 	'In-sample forecasting regression	
			smpl @first+T0+(length-1)+!t+!h @first+T0+(length-1)+!t+!h
			forecast(f=na) fcst
			fcst_gl_{%country}_h{!h} = fcst
			scalar actual = @elem(d{!h}l{%country},@otod(1+T0+(length-1)+{!t}+{!h})) 'Actual outcome													
			sq_error_gl_{%country}_h{!h} = (actual - fcst)^2	 'Squared forecast error																										

		next		

		smpl 1995:4+{!h} 2016:4
		rmse_gl(counter,{!h}+1) = @sqrt(@mean(sq_error_gl_{%country}_h{!h}))

	next
 
next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Ratio of RMSEs:  AO model augmented with global factor
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results: ratio of RMSEs
table(24,17) rmse_ratio_gl
rmse_ratio_gl(1,2) = "1q"
rmse_ratio_gl(1,4) = "2q"
rmse_ratio_gl(1,6) = "3q"
rmse_ratio_gl(1,8) = "4q"
rmse_ratio_gl(1,10) = "5q"
rmse_ratio_gl(1,12) = "6q"
rmse_ratio_gl(1,14) = "7q"
rmse_ratio_gl(1,16) = "8q"

scalar counter = 1  'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

	scalar counter = counter + 1
	rmse_ratio_gl(counter,1) = %country

	for !h=1 to maxh

		scalar index = !h+1
		scalar column = {!h}*2		
		rmse_ratio_gl(counter,column)  = @val(rmse_gl(counter,index))/@val(rmse_AO(counter,index)) 'Ratio of RMSEs

		'Statistical significance (10 percent level)
		smpl 1995:4+{!h} 2016:4
		scalar lag={!h}
		equation dm_gl_{%country}_h{!h}.ls(cov=hac,nodf,covbw=lag) (sq_error_gl_{%country}_h{!h} - sq_error_AO_{%country}_h{!h}) c
		scalar tstat = dm_gl_{%country}_h{!h}.@tstats(1)
		if tstat<-1.282 then
			rmse_ratio_gl(counter,column+1) = 1
		else 
			rmse_ratio_gl(counter,column+1) = 0
		endif		
		
	next

next

'Export results
rmse_ratio_gl.save(t=csv) "rmse_ratio_glAO_2016.csv"

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Forecasts: AO model augmented with global factor, rolling in-sample estimation window
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results
table(24,9) rmse_glr
rmse_glr(1,2) = "1q"
rmse_glr(1,3) = "2q"
rmse_glr(1,4) = "3q"
rmse_glr(1,5) = "4q"
rmse_glr(1,6) = "5q"
rmse_glr(1,7) = "6q"
rmse_glr(1,8) = "7q"
rmse_glr(1,9) = "8q"

'Estimate forecasting regressions
scalar counter = 1 'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
	
	scalar counter = counter + 1
	rmse_glr(counter,1) = %country
	
	for !h=1 to maxh	'Loop over forecast horizons

		series fcst_glr_{%country}_h{!h} = na	 'Series to store forecasts
		series sq_error_glr_{%country}_h{!h} = na 'Series to store squared forecast errors

		for !t = 0 to (T-T0-length-maxh)	'Loop over time periods

			smpl @first+T0+(length-1)+!t-window @first+T0+(length-1)+!t 'Rolling estimation window
			!h_minus = -!h
			!h_minus1 = -!h-1
			!h_minus2 = -!h-2
			!h_minus3 = -!h-3
			'equation reg_glr_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}l{%country} - d4l{%country}(!h_minus) = c(1)*((1/4)*(d1lcpi_global_avg(!h_minus) + d1lcpi_global_avg(!h_minus1) + d1lcpi_global_avg(!h_minus2) + d1lcpi_global_avg(!h_minus3)) - d4l{%country}(!h_minus)) 	'In-sample forecasting regression	
			equation reg_glr_{%country}_t{!t}_h{!h}.ls(cov=hac) d{!h}l{%country} - d4l{%country}(!h_minus) = c(1)*(d4lcpi_global_avg(!h_minus) - d4l{%country}(!h_minus)) 	'In-sample forecasting regression	
			smpl @first+T0+(length-1)+!t+!h @first+T0+(length-1)+!t+!h
			forecast(f=na) fcst
			fcst_glr_{%country}_h{!h} = fcst
			scalar actual = @elem(d{!h}l{%country},@otod(1+T0+(length-1)+{!t}+{!h})) 'Actual outcome													
			sq_error_glr_{%country}_h{!h} = (actual - fcst)^2	 'Squared forecast error																										

		next		

		smpl 1995:4+{!h} 2016:4
		rmse_glr(counter,{!h}+1) = @sqrt(@mean(sq_error_glr_{%country}_h{!h}))

	next
 
next

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Ratio of RMSEs:  Augmented AO model with global factor, rolling in-sample estimation window
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

'Table to store results: ratio of RMSEs
table(24,17) rmse_ratio_glr
rmse_ratio_glr(1,2) = "1q"
rmse_ratio_glr(1,4) = "2q"
rmse_ratio_glr(1,6) = "3q"
rmse_ratio_glr(1,8) = "4q"
rmse_ratio_glr(1,10) = "5q"
rmse_ratio_glr(1,12) = "6q"
rmse_ratio_glr(1,14) = "7q"
rmse_ratio_glr(1,16) = "8q"

scalar counter = 1  'Country number for loop
for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2

	scalar counter = counter + 1
	rmse_ratio_glr(counter,1) = %country

	for !h=1 to maxh

		scalar index = !h+1
		scalar column = {!h}*2		
		rmse_ratio_glr(counter,column)  = @val(rmse_glr(counter,index))/@val(rmse_AO(counter,index)) 'Ratio of RMSEs

		'Statistical significance (10 percent level)
		smpl 1995:4+{!h} 2016:4
		scalar lag={!h}
		equation dm_glr_{%country}_h{!h}.ls(cov=hac,nodf,covbw=lag) (sq_error_glr_{%country}_h{!h} - sq_error_AO_{%country}_h{!h}) c
		scalar tstat = dm_glr_{%country}_h{!h}.@tstats(1)
		if tstat<-1.282 then
			rmse_ratio_glr(counter,column+1) = 1
		else 
			rmse_ratio_glr(counter,column+1) = 0
		endif		
		
	next

next

'Export results
rmse_ratio_glr.save(t=csv) "rmse_ratio_glAO_rolling_2016.csv"

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Figure 4
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

!n = 23 'Number of countries

for !h=1 to 8 'Loop over forecast horizons
	
	smpl @all

	series rmse_gl_h{!h}_avg = na
	series rmse_glr_h{!h}_avg = na

	for !t = 0 to T-@dtoo("1995:1")-maxh	'Loop over time periods
	
		smpl 1994:4+{!t}+{!h}-36 1994:4+{!t}+{!h} 'Note: CM use 37-quarter rather than 40-quarter window
		
		scalar rmse_gl_h{!h}_avg_t = 0	
		scalar rmse_glr_h{!h}_avg_t = 0	
	
			for %country cpi_aut cpi_bel cpi_fin cpi_fra cpi_ger cpi_ita cpi_ned cpi_por cpi_esp cpi_irl cpi_den cpi_gre cpi_swe cpi_uk cpi_nor cpi_sui cpi_can cpi_jpn cpi_usa cpi_aus cpi_nzl cpi_lux cpi_u2
			
				'Average across forecasts for each model
				scalar rmse_gl_h{!h}_avg_t = rmse_gl_h{!h}_avg_t + @sqrt(@mean(sq_error_gl_{%country}_h{!h}))
				scalar rmse_glr_h{!h}_avg_t = rmse_glr_h{!h}_avg_t + @sqrt(@mean(sq_error_glr_{%country}_h{!h}))
				
			next
		
			smpl 1994:4+{!t}+{!h} 1994:4+{!t}+{!h}

			series rmse_gl_h{!h}_avg = rmse_gl_h{!h}_avg_t/{!n}
			series rmse_glr_h{!h}_avg = rmse_glr_h{!h}_avg_t/{!n}
	
	next

next

'Export series
smpl @all
write(t=xls,na=.,d=c,dates) "rmse_glAO_2016" rmse_gl_h1_avg rmse_gl_h4_avg rmse_gl_h8_avg
write(t=xls,na=.,d=c,dates) "rmse_glrAO_2016" rmse_glr_h1_avg rmse_glr_h4_avg rmse_glr_h8_avg

'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
' Save workfile
'----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

wfsave "AO_2016"


