#ifndef __FILE_SNP_BASE_H_SEEN__
#define __FILE_SNP_BASE_H_SEEN__

/*-----------------------------------------------------------------------------

Copyright (C) 2004, 2006, 2013.

A. Ronald Gallant
Post Office Box 659
Chapel Hill NC 27514-0659
USA   

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/

#include "libscl.h"

namespace snp {
  
  class keyword {
  private:
    std::string kw;
  public:
    keyword() : kw() {}
    keyword(const char* str) : kw(str) {}
    std::string set_keyword(const char* str) {return kw = str;}
    bool operator()(const std::string& str) const 
    { return str.find(kw) != std::string::npos; }
  };

  struct optparms {
    std::string pname;
    REAL snpver;
    INTEGER itmax0;
    INTEGER itmax1;
    REAL toler;
    bool print;
    INTEGER task;
    INTEGER extra;
    REAL sfac;
    INT_32BIT iseed;
    INTEGER ngrid;
    bool kilse;
  };
  
  struct datparms {
    INTEGER M;
    INTEGER n;
    INTEGER drop;
    INTEGER cond;
    bool reread;
    std::string dsn;
    scl::intvec fields;
    INTEGER panels;
  };
  
  struct tranparms {
    bool useold;
    bool diag;
    INTEGER squash;
    REAL inflec;
    scl::realmat mean;
    scl::realmat variance;
  };
  
  class trnfrm {
  private:
    datparms dpm;
    tranparms tpm;
    scl::realmat R;
    scl::realmat P;
    REAL detP;
  public:
    trnfrm(const datparms& dp,const tranparms& tp,
      const scl::realmat& data);
    trnfrm();
    ~trnfrm() { }
    trnfrm(const trnfrm& tr);
    trnfrm& operator=(const trnfrm& tr);
    const datparms& get_datparms() const {return dpm;}
    const tranparms& get_tranparms() const {return tpm;}
    const scl::realmat& get_R() const {return R;}
    const scl::realmat& get_P() const {return P;}
    REAL get_detP() const {return detP;}
    void set_n(INTEGER n) {dpm.n=n;}
    void normalize(scl::realmat& y) const;
    void unnormalize(scl::realmat& y) const;
    void unscale(scl::realmat& sigma) const;
    void spline(scl::realmat& x) const;
    void logistic(scl::realmat& x) const;
  };
  
  class datread_base {
  public:
    virtual void initialize(datparms dpm) = 0;
    virtual bool read_data(scl::realmat& data) = 0;
    virtual ~datread_base() { }
  };
  
  class ancillary_base {
  public:
    virtual void set_XY(const scl::realmat* x,
      const scl::realmat* y) = 0;
    virtual bool initialize(std::ostream* out_stream) = 0;
    virtual bool initialize(std::string out_filename) = 0;
    virtual bool calculate() = 0;
    virtual bool finalize() = 0;
    virtual ~ancillary_base() { }
  };
  
}

#endif
