#ifndef __FILE_MLE_BASE_H_SEEN__
#define __FILE_MLE_BASE_H_SEEN__

/*-----------------------------------------------------------------------------

Copyright (C) 2013.

A. Ronald Gallant
Post Office Box 659
Chapel Hill NC 27514-0659
USA   

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/

#include "realmat.h"

namespace mle {

  class keyword {
  private:
    std::string kw;
  public:
    keyword() : kw() {}
    keyword(const char* str) : kw(str) {}
    std::string set_keyword(const char* str) {return kw = str;}
    bool operator()(const std::string& str) const
    { return str.find(kw) != std::string::npos; }
  };

  struct estblock {
    std::string pname;
    REAL mlever;
    INTEGER proptype;
    bool print;
    INTEGER seed;
    INTEGER lchain;
    INTEGER nfile;
    REAL sclfac;
    REAL temperature;
    INTEGER stride;
    bool kilse;
    INTEGER lhac;
    bool draw_from_prior;
  };

  struct datblock {
    INTEGER M;
    INTEGER n;
    std::string dsn;
    scl::intvec fields;
    std::string fieldline;
    bool read_data(scl::realmat& data);
    bool read_data(const std::string& pathname, scl::realmat& data);
  };

  struct modblock {
    INTEGER len_mod_parm;
    INTEGER len_mod_func;
    bool    is_mod_parmfile;
    std::string mod_parmfile;
  };

  struct objblock {
    bool    is_obj_parmfile;
    std::string obj_parmfile;
  };

}
#endif
