#ifndef __FILE_TREE_SIM_H_SEEN__
#define __FILE_TREE_SIM_H_SEEN__

#include "libscl.h"

/*
Parameters:
rho[1] = alpha, autoregressive parameter of log endowment
rho[2] = sigma, sdev of log endowment autoregression
rho[3] = beta,  discount rate of crra utility function
rho[4] = gamma, risk aversion of crra utility function
*/

struct tree_variables {
  INTEGER N;   // simulation length
  scl::realmat log_consumption;
  scl::realmat log_stock_price;
  scl::realmat log_marginal_rate_of_substitution;
  scl::realmat log_consumption_growth;
  scl::realmat geometric_stock_return;
  scl::realmat geometric_risk_free_rate;
  scl::realmat pricing_errors;
  tree_variables() { }
  tree_variables(INTEGER num_sim)
  : N(num_sim),
    log_consumption(N,1,0.0),
    log_stock_price(N,1,0.0),
    log_marginal_rate_of_substitution(N,1,0.0),
    log_consumption_growth(N,1,0.0),
    geometric_stock_return(N,1,0.0),
    geometric_risk_free_rate(N,1,0.0),
    pricing_errors(N,1,0.0)
  { }
  void resize(INTEGER num_sim)
  {
    N = num_sim;
    log_consumption.resize(N,1);
    log_stock_price.resize(N,1);
    log_marginal_rate_of_substitution.resize(N,1);
    log_consumption_growth.resize(N,1);
    geometric_stock_return.resize(N,1);
    geometric_risk_free_rate.resize(N,1);
    pricing_errors.resize(N,1);
  }
  std::vector<std::string> get_tree_variables(scl::realmat& vars);
};

extern bool tree_sim
  (const scl::realmat& rho, INTEGER n_sim, INT_32BIT& seed, tree_variables& mv);

#endif

