P  <- read.table("P.txt",header=TRUE)
Q <- read.table("Q.txt",header=TRUE)
yPCp <- read.table("yPCp.txt",header=TRUE)
dpdq <- read.table("dpdq.txt",header=TRUE)

ps.options(horizontal=FALSE,onefile=FALSE)
ps.options(pagecentre=TRUE)
ps.options(paper="letter")
ps.options(width=7.0,height=10.0)

filename <- "policy_C.eps"
postscript(file=filename)
par(mfrow=c(2,1),mar=c(4.5,4,1.5,2)+0.1) # mar=c(b,l,t,r)

plot(yPCp$C,yPCp$P,type="n",xlab="Consumption",ylab="Price")
  lines(yPCp$C,yPCp$P,col="black");
  points(P$C,P$P,col="black",pch="|");

plot(yPCp$P,yPCp$C,type="n",ylab="Consumption",xlab="Price")
  lines(yPCp$P,yPCp$C,col="black");
  points(Q$P,Q$C,col="black",pch="|");

dev.off()

ps.options(horizontal=FALSE,onefile=FALSE)
ps.options(pagecentre=TRUE)
ps.options(paper="letter")
ps.options(width=7.0,height=7.0)

filename <- "policy_uc.eps"
postscript(file=filename)
par(mfrow=c(2,1),mar=c(4.5,4,2,2)+0.1) # mar=c(b,l,t,r)

plot(yPCp$y,yPCp$P,type="n",xlab="Log Endowment",ylab="Price",main="P(y)")
  lines(yPCp$y,yPCp$P,col="black");
  points(P$y,P$P,col="black",pch="|");

plot(yPCp$P,yPCp$y,type="n",ylab="Log Endowment",xlab="Price",main="Q(P)")
  lines(yPCp$P,yPCp$y,col="black");
  points(Q$P,Q$y,col="black",pch="|");

dev.off()

filename <- "policy_lc.eps"
postscript(file=filename)
par(mfrow=c(2,1),mar=c(4.5,4,2,2)+0.1) # mar=c(b,l,t,r)

plot(yPCp$y,yPCp$p,type="n",xlab="Log Endowment",ylab="Log Price",main="p(y)")
  lines(yPCp$y,yPCp$p,col="black");
  points(P$y,P$p,col="black",pch="|");

plot(yPCp$p,yPCp$y,type="n",ylab="Log Endowment",xlab="Log Price",main="q(p)")
  lines(yPCp$p,yPCp$y,col="black");
  points(log(Q$P),Q$y_alt,col="black",pch="|");

dev.off()

filename <- "policy_dpdq.eps"
postscript(file=filename)
par(mfrow=c(2,1),mar=c(4.5,4,2,2)+0.1) # mar=c(b,l,t,r)

plot(dpdq$y,dpdq$dp,type="n",xlab="Log Endowment",ylab="dp/dy",main="dp(y)")
  lines(dpdq$y,dpdq$dp,col="black");

plot(dpdq$p,dpdq$dq,type="n",ylab="dy/dp",xlab="Log Price",main="dq(p)")
  lines(dpdq$p,dpdq$dq,col="black");

dev.off()
