library(MASS)

ps.options(horizontal=FALSE,onefile=FALSE)
ps.options(pagecentre=TRUE)
ps.options(paper="letter")
ps.options(width=7.0,height=10.0)

mv <- read.table("tree_vars.txt",sep="",header=TRUE)

c <- mv[,"log_consumption"]
p <- mv[,"log_stock_price"]
e <- mv[,"pricing_errors"]

lcg <- mv[,"log_consumption_growth"]
lsr <- mv[,"geometric_stock_return"]

print(range(c))
print(range(p))
print(range(e))

phat <- p - p*e

postscript(file="errors.eps")
par(mfrow=c(3,1),mar=c(2.5,4,1.5,2)+0.1) # mar=c(b,l,t,r)

#plot(c,p,type="n",ylab="")
#points(c,p,pch="o")

plot(c,e,type="n",ylab="")
points(c,lsr*e,pch="o")

plot(c,lsr*e,type="n",ylab="")
points(c,lsr*e,pch="o")

plot(c,lcg*e,type="n",ylab="")
points(c,lcg*e,pch="o")

#plot(c,phat,type="n",ylab="")
#points(c,phat,pch="o")

#plot(c(c,c),c(p,phat),type="n",ylab="")
#points(c,phat,pch="o")
#points(c,phat,pch="+")


dev.off()
