#include "libscl.h"

using namespace std;
using namespace scl;

int main(int argc, char** argp, char** envp)
{

  REAL left = -35.0;
  REAL rite =  35.0;

  INTEGER num = 100;

  REAL lo =  REAL_MAX;
  REAL hi = -REAL_MAX;

  for (INTEGER i=1; i<=num+1; ++i) {
    REAL z = left + (rite - left)*REAL(i-1)/REAL(num);
    REAL tz = tanh(z/4.0);
    REAL rz = -4.0*(1.0 - tz)/(1.0 - pow(tz,2));
    REAL adj = pow(1.0-M_E,2)*fabs(rz);
    lo = adj < lo ? adj : lo;
    hi = adj > hi ? adj : hi;
    cout << fmt('f',8,3,z) << fmt('e',17,8,tz) << fmt('e',17,8,rz)
         << fmt('e',17,8,adj) << '\n';
  }
  cout << '\n';
  cout << "range = " << fmt('e',12,5,lo) << fmt('e',12,5,hi) << '\n';
  return 0;
}

