#ifndef __FILE_CALIBRATE_H_SEEN__
#define __FILE_CALIBRATE_H_SEEN__

#include "libscl.h"
#include "tree_policy.h"

/*
Parameters:
rho[1] = alpha, autoregressive parameter of log endowment
rho[2] = sigma, sdev of log endowment autoregression
rho[3] = beta,  discount rate of crra utility function
rho[4] = gamma, risk aversion of crra utility function
*/

const INTEGER n_parms = 4;       //Number of parameters
const INTEGER n_sim = 1000;      //Number of simulations, N  

struct tree_usrmod_variables {
  INTEGER N;   // simulation length
  scl::realmat log_consumption;
  scl::realmat log_stock_price;
  scl::realmat log_marginal_rate_of_substitution;
  scl::realmat log_consumption_growth;
  scl::realmat geometric_stock_return;
  scl::realmat geometric_risk_free_rate;
  tree_usrmod_variables() { }
  tree_usrmod_variables(INTEGER num_sim)
  : N(num_sim),
    log_consumption(N,1,0.0),
    log_stock_price(N,1,0.0),
    log_marginal_rate_of_substitution(N,1,0.0),
    log_consumption_growth(N,1,0.0),
    geometric_stock_return(N,1,0.0),
    geometric_risk_free_rate(N,1,0.0)
  { }
  std::vector<std::string> get_tree_usrmod_variables(scl::realmat& mv);
};

extern bool gen_sim (const scl::realmat& rho, scl::realmat& sim, 
  scl::realmat& stats);

extern void write_usrvar(const scl::realmat& rho, const char* filename);

#endif
