#ifndef __FILE_MLEUSR_H_SEEN__
#define __FILE_MLEUSR_H_SEEN__

/*-----------------------------------------------------------------------------

Copyright (C) 2013, 2016, 2018

A. Ronald Gallant
Post Office Box 659
Chapel Hill NC 27514-0659
USA   

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/
#include "libmle.h"
#include "mle_base.h"
#include "crra_mf.h"
#include "spline_interpolator.h"

namespace mle {
    
  class crra_usrmod;

  typedef crra_usrmod usrmod_type;

  const INTEGER n_parms = 2;        //Number of mrs parameters: beta, gamma
  const INTEGER n_funcs = 1;        //None
  const INTEGER n_data_rows = 2;    //lsr, lcg
  const INTEGER n_data_cols = 5000; //annual
  const INTEGER n_moments = 3;
  const INTEGER HAC_lags = 0;

  class crra_usrmod : public libmle::usrmod_base {
    scl::realmat parms;
    scl::realmat data;
    scl::realmat prior_mean;
    scl::realmat prior_sdev;
    crra_moment_function crramf;
    scl::gmm crragmm;
    REAL ridge;
    INTEGER sample_size;
    scl::spline_interpolator Fz1;
    scl::spline_interpolator qnorm;
  public:
    crra_usrmod
      (const scl::realmat& dat, INTEGER len_mod_parm, INTEGER len_mod_func,
       const std::vector<std::string>& mod_pfvec,
       const std::vector<std::string>& mod_alvec, 
       std::ostream& detail);
    INTEGER len_rho() 
      {return n_parms;}
    INTEGER len_stats() 
      {return n_funcs;}
    bool get_stats(scl::realmat& stats) 
      {stats=scl::realmat(n_funcs,1,0.0); return true;}
    void get_rho(scl::realmat& rho) 
      {rho = parms;}
    void set_rho(const scl::realmat& rho) 
      {parms = rho;}
    bool support(const scl::realmat& rho);
    scl::den_val prior(const scl::realmat& rho, const scl::realmat& stats);
    scl::den_val likelihood();
    void write_usrvar(const char* filename);
  };

}
#endif
