/*-----------------------------------------------------------------------------

Copyright (C) 2018

A. Ronald Gallant
Post Office Box 659
Raleigh NC 27514-0659
USA

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/

#ifndef __FILE_LPRIOR_H_SEEN__
#define __FILE_LPRIOR_H_SEEN__

#include "realmat.h"

extern scl::denval lprior
  (INTEGER M, INTEGER L, INTEGER mrs_pos, INTEGER cf_pos, INTEGER years,
  const scl::realmat& parms, REAL lambda, const scl::realmat& target, 
  const scl::intvec& idx, scl::realmat& stats);

extern INTEGER frac_rho(INTEGER M, INTEGER L, const scl::realmat& rho,
    scl::realmat& b0, scl::realmat& B, scl::realmat& S, scl::realmat& R, 
    scl::realmat& theta);

extern INTEGER frac_tau(INTEGER M, INTEGER L, const scl::realmat& tau,
    scl::realmat& b0, scl::realmat& B, scl::realmat& S, scl::realmat& R);

extern REAL ssd
  (INTEGER M, INTEGER L, INTEGER mrs_pos, INTEGER cf_pos, INTEGER years,
  const scl::realmat& parms, REAL lambda, const scl::realmat& target, 
  const scl::intvec& idx, scl::realmat& stats);

#endif
