tmp <- scan("10314000.plt")

mu   <- tmp[1]
sig  <- tmp[2]
xinc <- tmp[3]

plta  <- matrix(tmp[4:length(tmp)],ncol=2,byrow=T)
nora  <- dnorm(plta[,1],mean=mu,sd=sqrt(sig))

tmp <- scan("11114000.plt")

mu   <- tmp[1]
sig  <- tmp[2]
xinc <- tmp[3]

pltg  <- matrix(tmp[4:length(tmp)],ncol=2,byrow=T)
norg  <- dnorm(pltg[,1],mean=mu,sd=sqrt(sig))

ps.options(horizontal=FALSE,onefile=FALSE)
ps.options(pagecentre=TRUE)
ps.options(paper="letter")
ps.options(width=7.0,height=6.0)

par(mfrow=c(1,1))

postscript(file="plt.eps")

plot(c(plta[,1],plta[,1],pltg[,1],pltg[,1]),c(plta[,2],nora,pltg[,2],norg),
  xlab=" ", ylab="",type="n")
lines(plta[,1],plta[,2],lty=1)
lines(plta[,1],nora,lty=2)
lines(pltg[,1],pltg[,2],lty=3)
text(plta[50,1]+1.05,plta[50,2]+.01,"SNP-ARCH")
text(pltg[50,1]+1.1,pltg[50,2]+.01,"SNP-GARCH")

dev.off()
