#ifndef __FILE_MLEUSR_H_SEEN__
#define __FILE_MLEUSR_H_SEEN__

/*-----------------------------------------------------------------------------

Copyright (C) 2018

A. Ronald Gallant
Post Office Box 659
Chapel Hill NC 27514-0659
USA   

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/
#include "libmle.h"
#include "mle_base.h"
#include "snp_stat_mod.h"
#include "crra_mf.h"

namespace mle {
    
  class snp_usrmod;

  typedef snp_usrmod usrmod_type;

  class snp_usrmod : public libmle::usrmod_base {
  private:
    snp_stat_mod snpmod; 
    crra_moment_function crramf;
    scl::gmm crragmm;
    scl::realmat crra_parms;
    REAL lambda;
  public:
    snp_usrmod
      (const scl::realmat& dat, INTEGER len_mod_parm, INTEGER len_mod_func,
       const std::vector<std::string>& mod_pfvec,
       const std::vector<std::string>& mod_alvec, 
       std::ostream& detail);
    INTEGER len_rho() {return snpmod.len_parm();}
    INTEGER len_stats() {return snpmod.len_func()+4;}
    bool get_stats(scl::realmat& stats);
    void get_rho(scl::realmat& rho) {snpmod.get_parm(rho);}
    void set_rho(const scl::realmat& rho) {snpmod.set_parm(rho);}
    bool support(const scl::realmat& rho){return snpmod.support(rho);}
    scl::den_val prior(const scl::realmat& rho, const scl::realmat& stats);
    scl::den_val likelihood() {return snpmod.loglikelihood();}
    bool get_scores(scl::realmat& scores);  
    void write_usrvar(const char* filename);
  };
}
#endif
