library(MASS)

prefix <- "Z_0050"

ps.options(horizontal=FALSE,onefile=FALSE)
ps.options(pagecentre=TRUE)
ps.options(paper="letter")
ps.options(width=7.0,height=10.0)

filename <- paste(prefix,".dat",sep="");

z <- read.table(filename,sep="",header=FALSE)

z1 <- z[,1]
z2 <- z[,2]
z3 <- z[,3]

filename <- "00f0f0f0f1630000.sim"
tmp <- scan(filename);
s <- matrix(tmp,nrow=2000,ncol=3)

s1 <- s[,1]
s2 <- s[,2]
s3 <- s[,3]

print(mean(s1))
print(mean(s2))
print(mean(s3))

pvals <- seq(0.001,0.999,0.001)

filename <- paste(prefix,"_qq_snp.eps",sep="");
postscript(file=filename)
par(mfrow=c(3,1),mar=c(2.5,4,1.9,2)+0.1) # mar=c(b,l,t,r)

zval1 <- quantile(z1,probs=pvals)
zval2 <- quantile(z2,probs=pvals)
zval3 <- quantile(z3,probs=pvals)

sval1 <- quantile(s1,probs=pvals)
sval2 <- quantile(s2,probs=pvals)
sval3 <- quantile(s3,probs=pvals)

plot(sval1,zval1,type="n",ylab="",main=expression(Z[1]))
lines(sval1,zval1,lty="solid")

plot(sval2,zval2,type="n",ylab="",main=expression(Z[1]))
lines(sval2,zval2,lty="solid")

plot(sval3,zval3,type="n",ylab="",main=expression(Z[1]))
lines(sval3,zval3,lty="solid")

dev.off()



