library(MASS)

ps.options(horizontal=FALSE,onefile=FALSE)
ps.options(pagecentre=TRUE)
ps.options(paper="letter")
ps.options(width=7.0,height=5.0)

filename = "Fz.txt"
Fz <- read.table(filename,sep="",header=FALSE)

z1 <- Fz[,1]
p  <- Fz[,2]

filename = "Fz_knots.txt"
Fzk <- read.table(filename,sep="",header=FALSE)

z1k <- Fzk[,1]
pk  <- Fzk[,2]

filename = "Fz_spline.txt"
Fzs <- read.table(filename,sep="",header=FALSE)

z1s <- Fzs[,1]
ps  <- Fzs[,2]

filename <- "spline.eps"
postscript(file=filename)

plot(z1,p,type="n",ylab="",main=expression(Z[1]))
  lines(z1,p,lty="solid")
  points(z1k,pk)
  points(z1s,ps,lty="solid",col="red",pch='.')

dev.off()

filename = "normal_knots.txt"

n_points = 500;
x <- mat.or.vec(n_points,1);
p <- mat.or.vec(n_points,1);

for (i in 1:n_points) {
  x[i] = -4.0 + 8.0*(i-1)/(n_points-1);
  p[i] = pnorm(x[i])
}

filename = "normal_knots.txt"
Nk <- read.table(filename,sep="",header=FALSE)
xk <- Nk[,1]
pk <- Nk[,2]

filename <- "normal.eps"
postscript(file=filename)

plot(x,p,type="n",ylab="",main=expression(Z[1]))
  lines(x,p,lty="solid")
  points(xk,pk)

dev.off()
