#ifndef __FILE_MLEUSR_H_SEEN__
#define __FILE_MLEUSR_H_SEEN__

/*-----------------------------------------------------------------------------

Copyright (C) 2018

A. Ronald Gallant
Post Office Box 659
Chapel Hill NC 27514-0659
USA   

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-----------------------------------------------------------------------------*/
#include "libmle.h"
#include "mle_base.h"


// The data(M,n) are ../data/DCFdatayp.dat, M=5, n=86

// Row 1: Year: 1930 -- 2015
// Row 2: log of extracted mrs
// Row 3: growth of Real per capita GDP
// Row 4: GDP/Corporate profits
// Row 5: growth of Corporate profits

// Note: Input data is nxM, transposition to Mxn is by code in mlesrc

namespace mle {
    
  class dcf_usrmod;

  typedef dcf_usrmod usrmod_type;

  const INTEGER n_years = 30;       //Number of years in the yield curve
  const INTEGER n_parms = 11;       //Number params b0, B, R, & theta 
  const INTEGER n_funcs = 1;        //None
  const INTEGER n_data_rows = 5;    //year, mrs, gdp, gdp_cp, cp  
  const INTEGER n_data_cols = 86;   //Annual 1930 to 2015
  const INTEGER n_target = 10;

  const INTEGER VAR_M = 2;
  const INTEGER VAR_L = 1;

  const INTEGER loc_dat_yr     = 1;
  const INTEGER loc_dat_mrs    = 2;
  const INTEGER loc_dat_gdp    = 3;
  const INTEGER loc_dat_gdp_cp = 4;
  const INTEGER loc_dat_cp     = 5;

  const INTEGER loc_var_mrs    = 1;
  const INTEGER loc_var_cp     = 2;

  class dcf_usrmod : public libmle::usrmod_base {
  private:
    scl::realmat parms;
    scl::realmat data;
    REAL prior_mean_01;  // Campbell's estimate for US 1 yr is 0.00896
    REAL prior_sdev_01;  // 50 basis points is a half percent or 0.00500
    REAL prior_mean_30;  // Refers to yield at 30 years
    REAL prior_sdev_30;  
    scl::realmat target;
    scl::intvec idx;
    REAL lambda;
  public:
    dcf_usrmod
      (const scl::realmat& dat, INTEGER len_mod_parm, INTEGER len_mod_func,
       const std::vector<std::string>& mod_pfvec,
       const std::vector<std::string>& mod_alvec, 
       std::ostream& detail);
    INTEGER len_rho() {return n_parms;}
    INTEGER len_stats() {return n_funcs;}
    bool get_stats(scl::realmat& stats);
    void get_rho(scl::realmat& rho) {rho = parms;}
    void set_rho(const scl::realmat& rho) {parms = rho;}
    bool support(const scl::realmat& rho);
    scl::den_val prior(const scl::realmat& rho, const scl::realmat& stats);
    scl::den_val likelihood();
    void write_usrvar(const char* filename);
  };

}
#endif
