function [X,dateX,series,cat,transcode] = LoadingData(dataset)


%% Import Complete Dataset
[A,B]      = xlsread(dataset);
incl       = A(2,2:end);
data       = A(5:end,2:end);

%% Transformation Code
transcode  = A(1,2:end);
transcode  = transcode(:,incl~=0);

%% Scale Code
scalecode  = A(3,2:end);
scalecode  = scalecode(:,incl~=0);

%% Meta Series
series     = B(1,2:end);
series     = series(1,incl~=0);
data       = data(:,incl~=0);
cat        = A(4,2:end);
cat        = cat(:,incl~=0);
%% Return Series with same dimension and corresponding dates
%  Missing values where not calculated
%  -- Tcodes:

for j = 1:length(transcode)
    tr = transcode(j);
    if tr == 1
        X(:,j) = data(14:end,j);%% no transformation      
    elseif tr == 2             %% (1-L)
        X(:,j) = (data(14:end,j) - data(13:end-1,j));
    elseif tr == 3             %% (1-L)^2                    (NonBorrowed)
        X(:,j) = ((data(14:end,j)) - (data(2:end-12,j)))-((data(13:end-1,j)) - (data(1:end-13,j)));
    elseif tr == 4             %% log
        X(:,j) = log(data(14:end,j));       
    elseif tr == 5             %% (1-L)
        X(:,j) = (log(data(14:end,j)) - log(data(13:end-1,j)));
    elseif tr == 6             %% (1-L)^2 * log                 (Prices a la SW)
        X(:,j) = log(data(14:end,j)) - 2*log(data(13:end-1,j)) + log(data(12:end-2,j));
    elseif tr == 7             %% (1-L) * (1-L^{12}) * log      (Prices a la Giannone)
        X(:,j) = (log(data(14:end,j)) - log(data(2:end-12,j))) -(log(data(13:end-1,j)) - log(data(1:end-13,j)));
    elseif tr == 8             %% (1-L^{12}) * log              (Prices a la Lippi)
        X(:,j) = log(data(14:end,j)) - log(data(2:end-12,j));      
    end
end

dateraw    = A(5:end,1);
% dateX      = datevec(dateraw);
DateNumber = x2mdate(dateraw);
dateX      = datevec(DateNumber);
dateX      = dateX(14:end,:);

