 
/*REDUCED FORM EDUCATION RESULTS, Sample Cohorts Meghir & Palme (2005)*/

**Cohort: 1948, 1953
 
cd $output\tables					/*Change Folder to Export Tables*/
dir
 
use $anadata\anaMP_NS, clear
 
 
********************** 
/*Regression Results*/ 
********************** 
 
  set more off
 
 global x1 "i.cohort##sex"
 global x2 "i.cohort"
 
 
 d  $treat
 
**Outcome: Years of Education Education
  
global y   "yearseduc_FOB yrseduc_MP"
global samp "inrange(cohort,1938,1954)"
keep if (cohort==1948) | (cohort==1953)  			/*MP Sample Restriction*/
 
**Get 2SLS Infation Factor 
mat U = J(2,3,0)
mat list U
/*FIRST STAGE RESULTS, Sample Cohorts Meghir & Palme (2005)*/

local j=1

/*Both*/

foreach var of varlist  $y {	


	global sex "sex<=1" 
 
		reghdfe `var'   $treat   $x1  if  $samp &  $sex , cl(muniid)   absorb(muniid)  
		est sto regFE`var'
		sca Municipalities=e(N_clust)
		estadd scalar Municipalities 
		mat b = e(b)
		mat cov = e(V)	
		mat U[`j',1] =  b[1,1]	
		
		reghdfe  `var' $treat    $x1  if  $samp &  $sex & hife==0 , cl(muniid)   absorb(muniid)  
		est sto regFEfl`var'
		sca Municipalities=e(N_clust)
		estadd scalar Municipalities  
		mat b = e(b)
		mat cov = e(V)	
		mat U[`j',2] =  b[1,1]
		
		reghdfe  `var' $treat    $x1  if  $samp &  $sex & hife==1, cl(muniid)   absorb(muniid)  
		est sto regFEfh`var'  
		sca Municipalities=e(N_clust)
		estadd scalar Municipalities 
		mat b = e(b)
		mat cov = e(V)	
		mat U[`j',3] =  b[1,1] 
		
		local j=`j'+1
		
	global sex "sex==1" 
 
		reghdfe `var'  $treat   $x2  if  $samp &  $sex , cl(muniid)   absorb(muniid)  
		est sto regFEm`var'
		sca Municipalities=e(N_clust)
		estadd scalar Municipalities 
		
		reghdfe  `var' $treat    $x2  if  $samp &  $sex & hife==0 , cl(muniid)   absorb(muniid)  
		est sto regFEmfl`var'
		sca Municipalities=e(N_clust)
		estadd scalar Municipalities 
		
		reghdfe  `var' $treat    $x2  if  $samp &  $sex & hife==1, cl(muniid)   absorb(muniid)  
		est sto regFEmfh`var'  
		sca Municipalities=e(N_clust)
		estadd scalar Municipalities 
		
	global sex "sex==0" 
 
		reghdfe `var'  $treat   $x2  if  $samp &  $sex , cl(muniid)   absorb(muniid)  
		est sto regFEf`var'
		sca Municipalities=e(N_clust)
		estadd scalar Municipalities 
		
		reghdfe  `var' $treat    $x2  if  $samp &  $sex & hife==0 , cl(muniid)   absorb(muniid)  
		est sto regFEffl`var'
		sca Municipalities=e(N_clust)
		estadd scalar Municipalities 
		
		reghdfe  `var' $treat    $x2  if  $samp &  $sex & hife==1, cl(muniid)   absorb(muniid)  
		est sto regFEffh`var'  
		sca Municipalities=e(N_clust)
		estadd scalar Municipalities 
		
		
		
		
		
}


  foreach var of varlist   $y {	
	#delimit ;
	estout      regFE`var' regFEfl`var' regFEfh`var'    ,  
	 	 	keep($treat) cells(b(star fmt(3)) se(par fmt(3)))
		starlevels(* 0.10 ** 0.05 *** 0.01) 
		mlabels(,none) collabels(,none) eqlabels(,none) label unstack 
		varlabel($treat "\rule{0pt}{2ex} Reform")   stats(N Municipalities, labels("\rule{0pt}{2ex} N" "\rule{0pt}{2ex} Municipalities") fmt(%12.0fc )) 
		;
	#delimit cr 

}

  foreach var of varlist   $y {	
	#delimit ;
	estout        regFE`var' regFEfl`var' regFEfh`var'    using palme`var'.tex,      
	 	 style(tex)	keep($treat) cells(b(star fmt(3)) se(par fmt(3)))
		starlevels(* 0.10 ** 0.05 *** 0.01) 
		mlabels(,none) collabels(,none) eqlabels(,none) label unstack 
		varlabel($treat "\rule{0pt}{2ex} Reform")   stats(N Municipalities, labels("\rule{0pt}{2ex} N" "\rule{0pt}{2ex} Municipalities") fmt(%12.0fc )) 
		replace
		;
	#delimit cr 

}

  foreach var of varlist   $y {	
	#delimit ;
	estout      regFE`var' regFEfl`var' regFEfh`var'   regFEm`var' regFEmfl`var' regFEmfh`var'  regFEf`var' regFEffl`var' regFEffh`var'     using palme`var'_long.tex,      
	 	 style(tex)	keep($treat) cells(b(star fmt(3)) se(par fmt(3)))
		starlevels(* 0.10 ** 0.05 *** 0.01) 
		mlabels(,none) collabels(,none) eqlabels(,none) label unstack 
		varlabel($treat "\rule{0pt}{2ex} Reform")   stats(N Municipalities, labels("\rule{0pt}{2ex} N" "\rule{0pt}{2ex} Municipalities") fmt(%12.0fc )) 
		replace
		;
	#delimit cr 

}
 
 /*Extract Inflation Factor*/
 
 mat   A=U[1..1,.]
 mat  list  A
 mat   B=U[2..2,.]
 mat  list  B
 mat C = J(1,3,0)
 forvalues i=1(1)3 {
 	
	matrix C[1,`i']=round(A[1,`i']/B[1,`i'],.001)
 }
 
  mat  list  C
  	#delimit ;
		estout matrix(C) using   EIF_yoeMP.tex,      
	 	 style(tex)	  cells(b(star fmt(3)) )
		mlabels(,none) collabels(,none) eqlabels(,none) label unstack 
		varlabel(r1 "\rule{0pt}{2ex}  IV Inflation Factor $(\alpha^{{S}^{NEW}}/\alpha^{{S}^{TRAD}})$")    
		replace
		;
	#delimit cr 


/*SUR - Equivalence Test Statistic*/

mat SUR = J(1,3,0)

 cap drop interact
 gen interact=cohort*sex

 /*Demean estimates*/
  
  cap drop c_*
bysort muniid: center treat9b yearseduc_FOB yrseduc_MP cohort interact male

/*Fixed Effects Estimation*/
**Pooled 
regress   c_yrseduc_MP c_treat9b c_interact c_male c_cohort   ,   nocons
est store educ_old
regress   c_yearseduc_FOB c_treat9b c_interact c_male c_cohort   ,   nocons
est store educ_new

suest educ_old educ_new  , cluster(muniid)
test [educ_old_mean]c_treat9b = [educ_new_mean]c_treat9b

local a=string(round(r(p),.0001) , "%9.4fc")
mat SUR[1,1]=`a'
*mat SUR[2,1]=r(chi2)

cap drop c_*
bysort muniid hife: center treat9b yearseduc_FOB yrseduc_MP cohort interact male

global hife "hife==0"
**Father Low Education 
regress   c_yrseduc_MP c_treat9b c_interact c_male c_cohort if $hife  ,   nocons
est store educ_old
regress   c_yearseduc_FOB c_treat9b c_interact c_male c_cohort if $hife  ,   nocons
est store educ_new

suest educ_old educ_new  , cluster(muniid)
test [educ_old_mean]c_treat9b = [educ_new_mean]c_treat9b
local a=string(round(r(p),.0001) , "%9.4f")
mat SUR[1,2]=`a'

global hife "hife==1"
**Father High Education 
regress   c_yrseduc_MP c_treat9b c_interact c_male c_cohort if $hife  ,   nocons
est store educ_old
regress   c_yearseduc_FOB c_treat9b c_interact c_male c_cohort if $hife  ,   nocons
est store educ_new

suest educ_old educ_new  , cluster(muniid)
test [educ_old_mean]c_treat9b = [educ_new_mean]c_treat9b
local a=string(round(r(p),.0001) , "%9.4fc")
mat SUR[1,3]=`a'
 

  mat  list  SUR
  	#delimit ;
		estout matrix(SUR, fmt(4)) using   SURtest_yoeMP.tex,      
	 	 style(tex)	   
		mlabels(,none) collabels(,none) eqlabels(,none) label unstack 
		varlabel(r1 "\rule{0pt}{2ex}  p-value")    
		replace
		;
	#delimit cr 
 
 
exit 
 