/*Master File Replication MP 2005*/

** Version: 06/09/2019
** Authors: Martin Fischer, Gawain Heckley
** Data: SIP

graph set window fontface "Times New Roman"
set scheme s1mono
set matsize 11000

global size size(large)
global ls labsize(medlarge)
global legs size(medlarge) 

**Folder Data

global data  "\\micro.intra\projekt\P0524$\P0524_Gem\TN_MK_MF_School_reform_health_SES\"				/*Original Data*/
global mydata  "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\mydata"
global anadata  "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\mydata\MPreplikation"

**Folder Do-Files

global dofile  "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\do\MartinF\MPreplication\JAE"
global basedofile  "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\DataDoFiles"
 

**Folder Output

global outfiles "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\output\MPreplikation\outfiles"
global output "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\output\MPreplikation"
cd $output
dir

set more off
capture log close

/*Prepare Data*/

*do $basedofile\0_NewSIPGenSamp							/* Generate Base-Sample with Parents and base variables*/
*do $basedofile\1_NewSIPGenEarn_JAE						/* Generate earnings*/
*do $basedofile\2_NewSIPGenEduc							/* Generate educ*/
*do $basedofile\3_NewSIPGen_Parentbackground			/* Parents variables */
*do $dofile\gen_samppar_MPJAE							/* Generate analysis samples and final variables */
 
 
/* Files generated for Analysis

	1.) anaMP_NS.dta -> includes basesample, education variables and background (first stage, balancing)
	2.) ana_earn_full_NS.dta -> Earnings all years
	3.) palme_NS.dta -> Only Meghir & Palme Sample (Cohorts 1948, 1953)

*/ 

global treat "treat9b" 			/*Set Treatment without Helena Holmlund Correction (Raw)*/

cd $outfiles							/*Change outfile folder for saving intermediate Stata Files*/

/*Regression Analysis*/

** Table 1 and  Table 2

do $dofile\reg_maintab_JAE.do					/*Earnings Cohort 1948 and 1953*/
do $dofile\reg_maintab_educ_JAE.do				/*Education Cohort 1948 and 1953*/

** Figure 1 , C.1

do $dofile\reg_mainfigure_JAE.do				/*Estimates for Figure 1, C.1*/

**Figure 2 
do $dofile\Figure1.do							/*Balancing Regressions All 4 Reforms + Meghir & Palme (2005) Sample*/


** Appendix Table Full Sample Cohorts 1938 -- 1954 
 
do $dofile\reg_apptab_JAE.do					/*Earnings Cohort 1938 -- 1954*/
do $dofile\reg_apptab_educ_JAE.do				/*Education Cohort 1938 -- 1954*/

** Figure Appendix A1, C1

***** GH - data for figure A.1 comes from somewhere but don't know where
do $dofile\figureA1.do					/*Missing Compliers*/
do $dofile\figureC1.do					/*Effects on Levels of Education*/
 
** Table Appendix C1 descriptives

do $dofile\tableB2_descriptives.do

**Balancing Regressions**
** Table C.2, C.3 - Balancing tests

do $dofile\reg_apptab_bal_JAE.do 




/*REPLICATE RESULTS WITH HELENA HOLMLUND CORRECTION (EJ, 2015)*/

global outfiles "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\output\MPreplikation_corrected\outfiles"
global output "\\micro.intra\projekt\P0524$\P0524_gem\TN_MK_MF_School_reform_health_SES\output\MPreplikation_corrected"
cd $output
dir
 
global treat "treat9" 			/*Set Treatment with Helena Holmlund Correction*/
  
/*Regression Analysis*/

** Table 1 and  Table 2
do $dofile\reg_maintab_JAE.do					/*Earnings Cohort 1948 and 1953*/
do $dofile\reg_maintab_educ_JAE.do				/*Education Cohort 1948 and 1953*/

** Appendix Table Full Sample Cohorts 1938 -- 1954 
 
do $dofile\reg_apptab_JAE.do					/*Earnings Cohort 1938 -- 1954*/
do $dofile\reg_apptab_educ_JAE.do				/*Education Cohort 1938 -- 1954*/
 
 
 
 
 
 
