/*Figure Appendix C1*/


use $anadata\anaMP_NS, clear

global samp "(cohort==1948) | (cohort==1953)"
keep if $samp

global regopt2 "absorb(muniid)  cluster(muniid)"
global x1 "i.cohort##sex"
 
  
*Generate Dummies for School Variable (based on FoB1970) 
replace yrseducFOB=9 if yrseducFOB==9.5			/*Treat Realskola as Comprehensive*/
tab yrseducFOB, gen(school)

gen uppsec=0
replace uppsec=2 if yrseducFOB==11 
replace uppsec=3 if yrseducFOB==12 
replace uppsec=1 if 	educLISA==317 | educLISA==313 | educLISA==310	/* One Year Vocational Training*/
replace uppsec=2 if 	educLISA==327 | educLISA==323 | educLISA==320	/* Two Year Vocational Training*/
replace uppsec=3 if 	educLISA==337 | educLISA==333 | educLISA==330	/* Two Year Vocational Training*/

replace uppsec=. if yrseducFOB==. & educLISA==.
tab uppsec, gen(upper)

*Generate Dummies for Years of Postschooling
gen uni=0  if educLISA<400
replace uni=1 if 	educLISA>400 & educLISA<430							/* One Year Post Secondary Education*/
replace uni=2 if 	educLISA>=520 & educLISA<530										/* Two Years Post Secondary Education*/
replace uni=3 if 	educLISA>=530 & educLISA<540											/* Three Years Post Secondary Education*/
replace uni=4 if 	educLISA>=540 & educLISA<550											/* Four Years Post Secondary Education*/
replace uni=5 if 	educLISA>=550 & educLISA<560											/* Five Years Post Secondary Education*/
replace uni=7 if 	educLISA>=600 & educLISA<640						/* Lic. university education */
replace uni=9 if 	educLISA==640										/* PhD university education */
tab uni , gen(post)

 *lab var $treat "Reform" 
  *d  $treat

  cd $outfiles\
 
/*First Graph: School Degrees*/ 
 * GH only 5 levels of FOB schooling: 7,8,9,11,12
global dependent "school1 school2 school3 school4 school5" 
 

  **ALL**
 
 foreach i of global dependent {
 
_regress `i' $x1    $treat , $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'.dta,replace )  
 
 }

 **BY FATHERS EDUCATION**
 
  foreach i of global dependent {
 
_regress `i' $x1    $treat  if hife==0, $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'l.dta,replace )  
 
 } 
 
 foreach i of global dependent {
 
_regress `i' $x1    $treat  if hife==1, $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'h.dta,replace )  
 
 } 
 
  /*Second Graph: Upper secondary School Degrees*/ 
 
global dependent "upper2 upper3 upper4" 
 
 

  **ALL**
 
 foreach i of global dependent {
 
_regress `i' $x1    $treat , $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'.dta,replace )  
 
 }

 **BY FATHERS EDUCATION**
 
  foreach i of global dependent {
 
_regress `i' $x1    $treat  if hife==0, $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'l.dta,replace )  
 
 } 
 
 foreach i of global dependent {
 
_regress `i' $x1    $treat  if hife==1, $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'h.dta,replace )  
 
 } 
 
 
 /*Graph: Post-Schooling Degrees*/ 
 * GH added postschool8 as this level was missing
global dependent "post1 post2 post3  post4  post5 post6 post7 post8 " 
 
**ALL**
 
 foreach i of global dependent {
 
_regress `i' $x1    $treat , $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'.dta,replace )  
 
 }

 **BY FATHERS EDUCATION**
 
  foreach i of global dependent {
 
_regress `i' $x1    $treat  if hife==0, $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'l.dta,replace )  
 
 } 
 
 foreach i of global dependent {
 
_regress `i' $x1    $treat  if hife==1, $regopt2
  parmest ,format(estimate min95 max95)    saving(`i'h.dta,replace )  
 
 } 
 
 
  ******************
 /*GRAPH OUTCOMES*/
 ******************
 
 /*Plot Schooling by Fathers Education*/ 
 use $outfiles\school1h.dta, clear
 gen years=7
append using $outfiles\school2h.dta
 replace years=8 if years==.
append using $outfiles\school3h.dta 
replace years=9 if years==.
/*append using $outfiles\school4h.dta 
replace years=11 if years==.
append using $outfiles\school5h.dta 
 replace years=12 if years==.
 */
 gen hife=1
 
 
append using $outfiles\school1l.dta
 replace years=7  if years==.
append using $outfiles\school2l.dta
 replace years=8 if years==.
append using $outfiles\school3l.dta 
replace years=9 if years==.
/*append using $outfiles\school4l.dta 
replace years=11 if years==.
append using $outfiles\school5l.dta 
replace years=12 if years==.
 */
 replace hife=0 if hife==. 
   
  keep if parm=="$treat"
 
 replace years=years-0.1 if hife==0
 replace years=years+0.1 if hife==1
  
#delimit ;
 graph tw  (rcap min95 max95 years  if hife==0, color(gray) fintensity(40) ) (scatter estimate years if hife==0 , msym(Oh)) 
 (rcap min95 max95 years  if hife==1, color(gray) fintensity(40) ) (scatter estimate years if hife==1 , msym(Th)) 
 , 
				ytitle("Reform Effect", $size) yline(0)
				xtitle("Years of Education", $size)
				xscale( range(6.5 9.5)   )
				ylab(-0.2(0.2)0.4, $ls)
				xlab( 7 8 9 , nogrid angle(0) $ls)
				legend(order(2 "Low FE"  4  "High FE") col(1)  position(10) ring(0)   symx(5) region(col(white)) $legs   )
				yscale(    noex )
				ylab(  , nogrid )
				graphregion(color(white) lwidth(large)) 
				bgcolor(white)	 
 			;
#delimit cr	

graph save  $output\Figures\schooling.gph, replace
graph export $output\Figures\schooling.pdf, replace
 

 
 
 /*Plot upper secondary schooling by Fathers Education*/ 
 use $outfiles\upper2h.dta, clear
 gen years=1
append using $outfiles\upper3h.dta
 replace years=2 if years==.
append using $outfiles\upper4h.dta 
replace years=3 if years==.
*append using $outfiles\school4h.dta 
* GH change - no 10 years for this sample 
 *replace years=10 if years==.
 *append using $outfiles\school5h.dta 
 *replace years=10 if years==.
 
 gen hife=1
 
 
append using $outfiles\upper2l.dta
 replace years=1  if years==.
append using $outfiles\upper3l.dta
 replace years=2 if years==.
append using $outfiles\upper4l.dta 
replace years=3 if years==.
*append using $outfiles\school4l.dta 
* GH change - no 10 years for this sample, saved 12 years as 10 and then re-labelled it in the graph
* replace years=10 if years==.
* append using $outfiles\school5l.dta 
 *replace years=10 if years==.
 
 replace hife=0 if hife==. 
   
  keep if parm=="$treat"
 
 replace years=years-0.1 if hife==0
 replace years=years+0.1 if hife==1
  
#delimit ;
 graph tw  (rcap min95 max95 years  if hife==0, color(gray) fintensity(40) ) (scatter estimate years if hife==0 , msym(Oh)) 
 (rcap min95 max95 years  if hife==1, color(gray) fintensity(40) ) (scatter estimate years if hife==1 , msym(Th)) 
 , 
				ytitle("Reform Effect", $size) yline(0)
				xtitle("Years of Upper Secondary Education", $size)
				xscale( range(0.5 3.5)   )
				ylab(-0.2(0.2)0.4, $ls)
				xlab( 1 2 3, nogrid angle(0) $ls)
				legend(order(2 "Low FE"  4  "High FE") col(1)  position(10) ring(0)   symx(5) region(col(white)) $legs   )
				yscale(    noex )
				ylab(  , nogrid )
				graphregion(color(white) lwidth(large)) 
				bgcolor(white)  	
 			;
#delimit cr	

graph save  $output\Figures\uppsec.gph, replace
graph export $output\Figures\uppsec.pdf, replace

 
 
 
  /*Plot Post-Schooling High Educated Fathers*/ 
 /*
use $outfiles\post1h.dta, clear
append using $outfiles\post2h.dta
append using $outfiles\post3h.dta 
append using $outfiles\post4h.dta 
append using $outfiles\post5h.dta 
append using $outfiles\post6l.dta 
append using $outfiles\post7l.dta 
*/
 /*Plot Schooling by Fathers Education*/ 
 
 

use $outfiles\post2h.dta, clear
gen years=1
append using $outfiles\post3h.dta 
replace years=2 if years==.
append using $outfiles\post4h.dta 
 replace years=3 if years==.
 append using $outfiles\post5h.dta 
 replace years=4 if years==.
  append using $outfiles\post6h.dta 
 replace years=5 if years==.
  append using $outfiles\post7h.dta 
 replace years=6 if years==.
   append using $outfiles\post8h.dta 
 replace years=7 if years==.
 
 gen hife=1
 
append using $outfiles\post2l.dta
 replace years=1 if years==.
append using $outfiles\post3l.dta 
replace years=2 if years==.
append using $outfiles\post4l.dta 
 replace years=3 if years==.
 append using $outfiles\post5l.dta 
 replace years=4 if years==.
  append using $outfiles\post6l.dta 
 replace years=5 if years==.
  append using $outfiles\post7l.dta 
 replace years=6 if years==.
   append using $outfiles\post8l.dta 
 replace years=7 if years==.
  
 replace hife=0 if hife==. 
   
  keep if parm=="$treat"
 
 replace years=years-0.1 if hife==0
 replace years=years+0.1 if hife==1
  
#delimit ;
 graph tw  (rcap min95 max95 years  if hife==0, color(gray) fintensity(40) ) (scatter estimate years if hife==0 , msym(Oh)) 
 (rcap min95 max95 years  if hife==1, color(gray) fintensity(40) ) (scatter estimate years if hife==1 , msym(Th)) 
 , 
				ytitle("Reform Effect", $size) yline(0)
				xtitle("Years of Tertiary Education", $size)
				xscale( range(0.5 7.5)   )
				ylab(-0.2(0.2)0.4, $ls)
				xlab( 1 2 3 4 5 6 "7" 7 "9", nogrid angle(0) $ls)
				legend(order(2 "Low FE"  4  "High FE") col(1)  position(10) ring(0)   symx(5) region(col(white)) $legs  )
				yscale(    noex )
				ylab(  , nogrid )
				graphregion(color(white) lwidth(large)) 
				bgcolor(white)	
				 
 			;
#delimit cr	
  
 graph save  $output\Figures\POSTschooling.gph, replace
graph export $output\Figures\POSTschooling.pdf, replace

  