**Appendix Figure A.1**
 
/*Graphics Setting*/
set scheme s1mono
graph set window fontface "Times New Roman"

global size size(large)
global ls labsize(medlarge)
global legs size(medlarge) 
 
 use $anadata\figure_miscomplier.dta, clear
 
 
 #delimit ;
 graph twoway 	(rarea comp1 comp2 cohort   , fc(gs12) lc(white))
				(line comp1 cohort , lp(solid) lc(gs3))
				(line comp2 cohort , lp(dash) lc(gs3))
 ,
				ytitle("Share", $size) 
				xtitle("Year of Birth", $size) 
				legend(order(2 "New Measure"   3 "Traditional Measure" 1 "Missed Compliers") col(3) symx(5) region(col(white) ) $legs )
				yscale( range(0 1)  ) 
				ylab(0(0.2)1, nogrid $ls) 
				graphregion(color(white) lwidth(large)) 
				bgcolor(white)	
				xlab(1932(4)1952, nogrid $ls) 
				xscale( range(1932 1954)  )
 ;
#delimit cr
 
 
 graph save $output\Figures\FolkvsREG_2.gph, replace
 graph export  $output\Figures\FolkvsREG_2.pdf, replace

 