

#delimit;


/* This a do file that construct the labor market history of the NCDS cohort members.

Status:

1 - schooling

2 - work

3 - unemployment 


*/

   

/****************************************************/

/*** HISTORY ***/

/****************************************************/      


/*** define status period by period ***/  


local 1=1;

local prd=100-73;

di `prd';

while `1'<=`prd' {;  /* initialize t periods variables - status, schooling, experience, wages */


    local age=`1'+14;

    cap drop Sta`1'; ge Sta`1'=0; label var Sta`1' "Status age `age'";

    cap drop Sch`1'; ge Sch`1'=0; label var Sch`1' "Schooling age `age'";    

    cap drop Qua`1'; ge Qua`1'=0; label var Qua`1' "Qualification age `age'";            

    cap drop Exp`1'; ge Exp`1'=0; label var Exp`1' "Experience age `age'";

    cap drop Wag`1'; ge Wag`1'=0; label var Wag`1' "Wage age `age'";              

    

    tempvar emp`1'W; ge `emp`1'W'=0; 

    tempvar emp`1'U; ge `emp`1'U'=0;

    tempvar emp`1'S; ge `emp`1'S'=0;

    tempvar emp`1'0; ge `emp`1'0'=0;

    

    local 1=`1'+1;

};       


cap drop StaM; ge StaM=0; label var StaM "Status Missing";

cap drop WagM; ge WagM=0; label var WagM "Wage Missing"; 

  

/*** education tempvars and locals ***/


/* define break (non-permanent interruption) from school */

tempvar br; ge `br'=0 if act15==7;  

tempvar tt; ge `tt'=0 if act15==7;

tempvar ss; ge `ss'=0 if act15==7;  

local k1=6; 


/* dates */

local j=16;     /* initialize monthly loop - April 1974 (1st period starting date)*/ 

local j1=16;

local j2=20;    /* September 1974 (1st period ending date)*/     

local j3=`prd';     /* number of years to be included */

local y=1;      /* initialize yearly loop */

local wyr=4;    /* initialize wage loop */


/* status categories */

local s1=1; /* schooling */ 

local s2=3; /* unemployment */


while `j' <=  `j2'+12*(`j3'-1) {;  /* Sep 1981 */   

    

    di " loop " `j';   

    

    if `j'< 12*8 {; /* checks for breaks in the first 6 years of education */

         

        /*  Check the number of breaks in the job history of NCDS

        cohort members. A break is defined as a `k1' months non-education

        period followed by a 3 months (or longer) education spell (act`j'==7). */ 

    

        local l1=`j'+1; /* 1 month past j */

        local l2=`j'+2; /* 2 months past j */

        qui replace `br'=`br'+1 if act`j'==7 & `tt'>=`k1' & (act`l1'==7 & act`l2'==7);

        qui replace `tt'=`tt'+1 if act`j'!=7 & act`j'!=-99;

        qui replace `tt'=0 if act`j'==7; 

    

    };

    

 /* (1) age 15+ - O Levels yr 1 */   

        

    if `j'>=`j1' & `j'<=`j2' {; /* Apr 74 - Aug 1974 */

        

        qui replace `emp`y'W'=`emp`y'W'+1 if inlist(act`j',1,2);    /* months in employemnt */

        qui replace `emp`y'U'=`emp`y'U'+1 if inlist(act`j',3,4,5);  /* months in unemployemnt */  

        qui replace `emp`y'S'=`emp`y'S'+1 if inlist(act`j',7);      /* months in education */  

        qui replace `emp`y'0'=`emp`y'0'+1 if inlist(act`j',-99);    /* months in no allocation */          


        if `j' ==`j2' {; 

        

            di "period " `y';

                        

            qui replace Sta`y'=1 if inrange(Exa,1,3);                                       /* Status = S */

            qui replace Sta`y'=3 if Sta`y'==0 & (`emp`y'U'>0 | `emp`y'W'>0 | `emp`y'S'>0);  /* Status = U */

            qui replace Sta`y'=. if inrange(Sta`y',`s1',`s2')-1!=0;                         /* Status missing */

            

            qui replace Sch`y'=1 if Sta`y'==1;                                

            

            local y=`y'+1; /* update y & z for next period */

            local z=`y'-1;


        };

    };

    

     /* (2) age 16 - A Level yr 1*/

         

        

    if `j'>=((`j2'+1)+12*(0)) & `j'<=`j2'+12*(1) {; /* Sep 74 - Aug 75 */

        

        qui replace `emp`y'W'=`emp`y'W'+1 if inlist(act`j',1,2);    /* months in employemnt */

        qui replace `emp`y'U'=`emp`y'U'+1 if inlist(act`j',3,4,5);  /* months in unemployemnt */  

        qui replace `emp`y'S'=`emp`y'S'+1 if inlist(act`j',7);      /* months in education */  


        if `j' ==`j2'+12*(`y'-1) {;  

        

            di "period " `y';    

                        

            qui replace Sta`y'=1 if inrange(Exa,2,3);                                           /* Status = S */

            qui replace Sta`y'=2 if Sta`y'==0 & (`emp`y'W'>`emp`y'U')  & `emp`y'W'>0;           /* Status = W */         

            qui replace Sta`y'=3 if Sta`y'==0 & (`emp`y'W'<=`emp`y'U') & `emp`y'U'>0;           /* Status = U */  

            qui replace Sta`y'=4 if Sta`y'==0 & (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U');        

            qui replace Sta`y'=. if inrange(Sta`y',`s1',`s2')-1!=0;                           /* Status missing */

            qui replace Sta`y'=. if Sta`z'==.;

                                    

            qui replace Sch`y'=2 if Sta`y'==1;

            qui replace Qua`y'=1 if inrange(Aca,1,3);  

            

            qui replace Exp`y'=Exp`z'+inlist(Sta`z',2);

            

            local y=`y'+1;

            local z=`y'-1;

            

        };

    };

    

     /* (3) age 17 - A Level yr 2 */

       

        

    if `j'>=((`j2'+1)+12*(1)) & `j'<=`j2'+12*(2) {; /* Sep 75 - Aug 76 */

        

        qui replace `emp`y'W'=`emp`y'W'+1 if inlist(act`j',1,2);    /* months in employemnt */

        qui replace `emp`y'U'=`emp`y'U'+1 if inlist(act`j',3,4,5);  /* months in unemployemnt */  

        qui replace `emp`y'S'=`emp`y'S'+1 if inlist(act`j',7);      /* months in education */  

        

        if `j' ==`j2'+12*(`y'-1) {;  

                        

            di "period " `y';    

                                    

            qui replace Sta`y'=1 if Sta`z'==1;                                                  /* Status = S */

            qui replace Sta`y'=2 if Sta`y'==0 & (`emp`y'W'>`emp`y'U')  & `emp`y'W'>0;           /* Status = W */         

            qui replace Sta`y'=3 if Sta`y'==0 & (`emp`y'W'<=`emp`y'U') & `emp`y'U'>0;           /* Status = U */

            qui replace Sta`y'=4 if Sta`y'==0 & (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U');                        

            qui replace Sta`y'=. if inrange(Sta`y',`s1',`s2')-1!=0;                           /* Status missing */

            qui replace Sta`y'=. if Sta`z'==.;

                        

            qui replace Sch`y'=2 if Sta`y'==1;

            qui replace Qua`y'=Qua`z'; 


            qui replace Exp`y'=Exp`z'+inlist(Sta`z',2);

            

            local y=`y'+1;

            local z=`y'-1;

                        

        };

    };

            

     /* (4) age 18 - HE yr 1 */

             

    if `j'>=((`j2'+1)+12*(2)) & `j'<=`j2'+12*(3) {; /* Sep 76 - Aug 77 */

        

        qui replace `emp`y'W'=`emp`y'W'+1 if inlist(act`j',1,2);    /* months in employemnt */

        qui replace `emp`y'U'=`emp`y'U'+1 if inlist(act`j',3,4,5);  /* months in unemployemnt */  

        qui replace `emp`y'S'=`emp`y'S'+1 if inlist(act`j',7);      /* months in education */  

        

        if `j' ==`j2'+12*(`y'-1) {;  

    

            di "period " `y';    

                                    

            qui replace Sta`y'=1 if inrange(Exa,3,3) & `br'==0;                         /* Status = S */

            qui replace Sta`y'=2 if Sta`y'==0 & (`emp`y'W'>`emp`y'U')  & `emp`y'W'>0;   /* Status = W */         

            qui replace Sta`y'=3 if Sta`y'==0 & (`emp`y'W'<=`emp`y'U') & `emp`y'U'>0;   /* Status = U */

            qui replace Sta`y'=4 if Sta`y'==0 & (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U');                        

            qui replace Sta`y'=. if inrange(Sta`y',`s1',`s2')-1!=0;                           /* Status missing */

            qui replace Sta`y'=. if Sta`z'==.;

                                    

            qui replace Sch`y'=3 if Sta`y'==1;

            qui replace Qua`y'=Qua`z';

            qui replace Qua`y'=2 if inrange(Aca,2,3);                 

                        

            qui replace Exp`y'=Exp`z'+inlist(Sta`z',2);

            

            local y=`y'+1;

            local z=`y'-1;

            

        };

    };

        

     /* (5) age 19 - HE yr 2 */

       

        

    if `j'>=((`j2'+1)+12*(3)) & `j'<=`j2'+12*(4) {; /* Sep 77 - Aug 78 */

        

        qui replace `emp`y'W'=`emp`y'W'+1 if inlist(act`j',1,2);    /* months in employemnt */

        qui replace `emp`y'U'=`emp`y'U'+1 if inlist(act`j',3,4,5);  /* months in unemployemnt */  

        qui replace `emp`y'S'=`emp`y'S'+1 if inlist(act`j',7);      /* months in education */  

                           

        if `j' ==`j2'+12*(`y'-1) {;  

                        

            di "period " `y';    


            qui replace Sta`y'=1 if Sta`z'==1 /*& (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U')*/;  /* Status = S */ 

            qui replace Sta`y'=2 if Sta`y'==0 & (`emp`y'W'>`emp`y'U')  & `emp`y'W'>0;           /* Status = W */         

            qui replace Sta`y'=3 if Sta`y'==0 & (`emp`y'W'<=`emp`y'U') & `emp`y'U'>0;           /* Status = U */

            qui replace Sta`y'=4 if Sta`y'==0 & (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U'); 

            qui replace Sta`y'=. if inrange(Sta`y',`s1',`s2')-1!=0;                           /* Status missing */

            qui replace Sta`y'=. if Sta`y'!=1 & Sta`z'==1;

            qui replace Sta`y'=. if Sta`z'==.;

                                    

            qui replace Sch`y'=3 if Sta`y'==1;

            qui replace Qua`y'=Qua`z';


            qui replace Exp`y'=Exp`z'+inlist(Sta`z',2);

            

            local y=`y'+1;

            local z=`y'-1;

            local zz=`y'-2;            

                        

        };

    };      

    

     /* (6) age 20 - HE yr 3 */

   

        

    if `j'>=((`j2'+1)+12*(4)) & `j'<=`j2'+12*(5) {; /* Sep 78 - Aug 79 */

    

        qui replace `emp`y'W'=`emp`y'W'+1 if inlist(act`j',1,2);    /* months in employemnt */

        qui replace `emp`y'U'=`emp`y'U'+1 if inlist(act`j',3,4,5);  /* months in unemployemnt */  

        qui replace `emp`y'S'=`emp`y'S'+1 if inlist(act`j',7);      /* months in education */  

                            

        if `j' ==`j2'+12*(`y'-1) {;  

        

            di "period " `y';    

                        

            qui replace Sta`y'=1 if Sta`z'==1 /*& (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U')*/;  /* Status = S */

            qui replace Sta`y'=2 if Sta`y'==0 & (`emp`y'W'>`emp`y'U')  & `emp`y'W'>0;   /* Status = W */         

            qui replace Sta`y'=3 if Sta`y'==0 & (`emp`y'W'<=`emp`y'U') & `emp`y'U'>0;   /* Status = U */

            qui replace Sta`y'=4 if Sta`y'==0 & (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U');

            qui replace Sta`y'=. if inrange(Sta`y',`s1',`s2')-1!=0;                           /* Status missing */

            qui replace Sta`y'=. if Sta`y'!=1 & Sta`z'==1;

            qui replace Sta`y'=. if Sta`y'!=1 & Sta`zz'==1;             

            qui replace Sta`y'=. if Sta`z'==.;

                        

            qui replace Sch`y'=3 if Sta`y'==1;

            qui replace Qua`y'=Qua`z';


            qui replace Exp`y'=Exp`z'+inlist(Sta`z',2);

            

            local y=`y'+1;

            local z=`y'-1;

                         

        };

    };


     /* (7) age 21 - work (HE yr 4 recoded into work) */

       


    if `j'>=((`j2'+1)+12*(5)) & `j'<=`j2'+12*(6) {; /* Sep 79 - Aug 80 */

        

        qui replace `emp`y'W'=`emp`y'W'+1 if inlist(act`j',1,2);    /* months in employemnt */

        qui replace `emp`y'U'=`emp`y'U'+1 if inlist(act`j',3,4,5);  /* months in unemployemnt */  

        qui replace `emp`y'S'=`emp`y'S'+1 if inlist(act`j',7);      /* months in education */  

        

        if `j' ==`j2'+12*(`y'-1) {;  

        

            di "period " `y';    

            

            qui replace Sta`y'=1 if Sta`z'==1 & (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U') & `br'==0;     /* Status = S */

            qui replace Sta`y'=2 if Sta`y'==1 ;                                                              /* Status = W */         

            qui replace Sta`y'=2 if Sta`y'==0 & (`emp`y'W'>`emp`y'S') & (`emp`y'W'>`emp`y'U') & `emp`y'W'>0; /* Status = W */         

            qui replace Sta`y'=3 if Sta`y'==0 & (`emp`y'U'>`emp`y'S') & (`emp`y'U'>`emp`y'W') & `emp`y'U'>0; /* Status = U */

            qui replace Sta`y'=4 if Sta`y'==0 & (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U');                        

            qui replace Sta`y'=. if inrange(Sta`y',`s1',`s2')-1!=0;                           /* Status missing */

            qui replace Sta`y'=. if Sta`z'==.;

                        

            qui replace Sch`y'=3 if Sta`y'==1;

            qui replace Qua`y'=Qua`z'; 

            qui replace Qua`y'=3 if Sta`z'==1 & inrange(Aca,3,3);                 


            qui replace Exp`y'=Exp`z'+inlist(Sta`z',2);

            

            local y=`y'+1;

            local z=`y'-1;

                        

        };

    };


    /* (8) age 22 & later */

      

        

    if `j'>=((`j2'+1)+12*(6)) {; /* Sep 80 -  */

        

        qui replace `emp`y'W'=`emp`y'W'+1 if inlist(act`j',1,2);    /* months in employemnt */

        qui replace `emp`y'U'=`emp`y'U'+1 if inlist(act`j',3,4,5);  /* months in unemployemnt */  

        qui replace `emp`y'S'=`emp`y'S'+1 if inlist(act`j',7);      /* months in education */  

        

        if `j' ==`j2'+12*(`y'-1) {;  

        

            di "period " `y';    


            qui replace Sta`y'=2 if Sta`y'==0 & (`emp`y'W'>`emp`y'S') & (`emp`y'W'>`emp`y'U') & `emp`y'W'>0; /* Status = W */         

            qui replace Sta`y'=3 if Sta`y'==0 & (`emp`y'U'>`emp`y'S') & (`emp`y'U'>`emp`y'W') & `emp`y'U'>0; /* Status = U */

            qui replace Sta`y'=4 if Sta`y'==0 & (`emp`y'S'>`emp`y'W') & (`emp`y'S'>`emp`y'U');                        

            qui replace Sta`y'=. if inrange(Sta`y',`s1',`s2')-1!=0;                           /* Status missing */

            qui replace Sta`y'=. if Sta`z'==.;

                        

            qui replace Qua`y'=Qua`z'; 

                        

            qui replace Exp`y'=Exp`z'+inlist(Sta`z',2);

            

            if `y'==8 | `y'==19 | `y'==27 {;

            

                qui replace Wag`y'=hrw`wyr' if hrw`wyr'!=. & inlist(Sta`y',2);

                qui replace WagM=WagM+1 if Sta`y'==2 & Wag`y'==0;     

                

                local wyr=`wyr'+1;

                

            };

            

            local y=`y'+1;

            local z=`y'-1;

                        

        };

    };            

    

    local j=`j'+1;

};



                                                                        

