function [Smat,Qmat,Tmat] = f_stats(np,ni,Sta,Prd,Typ,Qua,dimSc)

%% Initialiaze matrices
Smat=zeros(3,1,np);
Qmat=zeros(dimSc+1,1,np);
Tmat=zeros(20,1,np);

%% RESHAPE DATA
Prd=reshape(Prd',[ni*np,1]);
Sta=reshape(Sta',[ni*np,1]);
Qua=reshape(Qua',[ni*np,1]);
Typ=reshape(Typ',[ni*np,1]);

%% Define matrices

% Status
for y=1:np
    for z=1:3 % 3 status: 1 school, 2 work, 3 unemployment
        Smat(z,1,y)=sum(Sta(Prd==y)==z)/ni;
    end

% Qualification
    for z=0:dimSc % 4 schooling levels : 0 No Qual, 1 O Lev, 2 A Lev, 3 HE
        Qmat(z+1,1,y)=sum(Qua(Prd==y)==z)/ni;
    end

% Transition
    for z=1:20 % 20 transitions
        Tmat(z,1,y)=sum(Typ(Prd==y)==z)/ni;
    end

end

Smat(end+1,:,:)=sum(Smat);
Qmat(end+1,:,:)=sum(Qmat);
Tmat(end+1,:,:)=sum(Tmat);