function [Smat,Qmat,Tmat,Wmat,Kmat,TmatH,...
    QK2mat,QK0mat,QK2Hmat,QK0Hmat,WHmat,WXmat]=f_simulation(THETA)

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc 
global dimT tol
global beta tut1 tut2 tut3 rho
global AbMat YprMat
global nn np
global THETAF

a=length(THETAF);
pk=THETA(end-dimUc+1:end);

sigE1=THETA(a+1); 
sigE2=THETA(a+2); 
sigE3=THETA(a+3); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

sigU    = abs(THETA(01))    ;   % s.d error term in observed Wage

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SIMULATION
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Generate shocks

% Shock to simulate e in Rs
randn('seed',100);     % set seed of randon number generator (normal distribution)
x1=randn(nn,dimSc-1);   % generate random numbers (for every individual / choice)

% Shock to simulate unobserved heterogeneity 
rand('seed',7314);     % set seed of randon number generator (uniform distribution)
x4=rand(nn,1);          % generate random numbers (for every individual)

% Shock to simulate parental income
rand('seed',3441);     % set seed of randon number generator (uniform distribution)
x5=rand(nn,1);          % generate random numbers (for every individual)

%%% Generate Simulated Variables

Epss=[x1(:,1)*sigE1 x1(:,2)*sigE2  x1(:,3)*sigE3];     % define shocks for Rs

Schs=zeros(nn,np);          % Schooling: initialize
Quas=zeros(nn,np);          % Qualification variables
Typs=zeros(nn,np);          % Type: initialize     
Stas=zeros(nn,np);          % Status: initialize
Exps=zeros(nn,np);          % Experience: initialize     
Wags=zeros(nn,np);          % Wage: initialize
Prds=repmat(1:np,[nn,1]);   % Periods
ids=repmat(1:nn,[np,1]);    % id      

Stts=zeros(nn,np);          % transitions
Qlfs=zeros(nn,np);          % transitions
Trns=zeros(nn,np);          % transitions

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SOLVE MODEL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[Rw,Lam,Dta,Dta1,Phi,Vs,Vu,Vwu]=f_model(THETA); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% CHOICES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

HetMat=[Uc ones(length(Uc),1) [pk]*100]; % Unobserved Heterogeneity 
Hets=MySimulvar(HetMat,x4,nn);

for yy=1:np
    
    [Ab2s Ab0s]=MySimulvar2(AbMat{yy},nn); % simulated Skill age 16 from shock
    
    %%% Period 1 - age 15 / O Lev

    %%% Expected Next Period Life-Time Rewards
    VsS =MyLinear(Uc,K2,K0,squeeze(Vs(:,:,1,:,1))    ,Hets,Ab2s,Ab0s,'linear');
    VwuS=MyLinear(Uc,K2,K0,squeeze(Vwu(:,:,1,:,1,2)) ,Hets,Ab2s,Ab0s,'linear');
    
    auxsu=(Epss(:,1)>beta*VwuS-VsS);

    Stas(:,1)=auxsu*1+(1-auxsu)*3;  % choice S0 -> S1/W
    Typs(:,1)=auxsu*5+(1-auxsu)*6;
    Schs(:,1)=auxsu*1+(1-auxsu)*0;
    
    Stts(:,yy)=Stas(:,1);
    Trns(:,yy)=Typs(:,1);
    
    %%% Period 2 onwards 

    k=0;    % educational success
    for y=2:np   % periods
        z=y-1;  % lagged period
        
        if yy<y
            break
        end
    
        Exps(:,y)=Exps(:,z)+(Stas(:,z)==2); % experience
        Quas(:,y)=Quas(:,z); % qualification
        
        % update qualification
        if y==2 | y==4 | y==7   % select periods when qualification can be gained
            LamS=MyNormcdf(MyLinear(Uc,K2,Sc(1:dimSc-1),K0,Lam,Hets,Ab2s,Quas(:,y),Ab0s,'linear'));            
            for i=[AbMat{y}{2}]' % loop over skill  values        
                for j=[AbMat{y}{3}]' % loop over skill age 7 values        
                    for h=[0:1:dimUc-1] % loop over u.h.
                        indL=find((Ab2s==i)&(Ab0s==j)&(Stas(:,z)==1)&(Hets==h)); % define individuals who entered exams
                        if size(indL,1)>0
                            x=zeros(nn,1); % initialize shocks vector
                            randn('seed',(i*j*y)); % generate normal shocks 
                            x(indL,1)=randn(size(indL,1),1);
                            Quas(indL,y)=Quas(indL,y)+(x(indL)>MyNorminv((1-LamS(indL)))); % generate Quas|S1 to match data
                        end
                    end
                end
            end      
        end
        
        Qlfs(:,yy)=Quas(:,y);
       
        % assign job offer and job firing 
        DtaS=zeros(nn,1);    % initialize job offers vector 
        PhiS=zeros(nn,1);    % initialize job firing vector 
        D =MyNormcdf(MyLinear(Uc,K2,Sc,K0,Xc,Dta ,Hets,Ab2s,Quas(:,y),Ab0s,Exps(:,y),'linear'));
        D1=MyNormcdf(MyLinear(Uc,K2,Sc,K0,Xc,Dta1,Hets,Ab2s,Quas(:,y),Ab0s,Exps(:,y),'linear'));
        P =MyNormcdf(MyLinear(Uc,K2,Sc,K0,Xc,Phi ,Hets,Ab2s,Quas(:,y),Ab0s,Exps(:,y),'linear'));        
        for i=0:max(Quas(:,y))
            for j=0:max(Exps(:,y))
                for w=[AbMat{y}{2}]'
                    for h=[0:1:dimUc-1]
%                       for u=[Ab0Mat{y}(:,1)]' &(Ab0s==u) &(Ab0s==u)
                            % job offer
                            indD=find((Quas(:,y)==i)&(Exps(:,y)==j)&(Stas(:,z)~=2)&(Ab2s==w)&(Hets==h)); % not working before
                            if size(indD,1)>0
                                x=zeros(nn,1); % initialize shocks vector                   
                                randn('seed',(i*j*w*y)); %*u
                                x(indD,1)=randn(size(indD,1),1);
                                if y==2
                                    DtaS(indD)=(x(indD)>MyNorminv((1-D1(indD)))); % generate job offer
                                else
                                    DtaS(indD)=(x(indD)>MyNorminv((1-D(indD)))); % generate job offer
                                end
                            end         
                            % job firing
                            indP=find((Quas(:,y)==i)&(Exps(:,y)==j)&(Stas(:,z)==2)&(Ab2s==w)&(Hets==h)); % working before
                                if size(indP,1)>0
                                x=zeros(nn,1); % initialize shocks vector                   
                                randn('seed',(i*j*w*y)); %*u
                                x(indP,1)=randn(size(indP,1),1);
                                PhiS(indP)=(x(indP)>MyNorminv((1-P(indP)))); % generate job firing
                            end
%                       end
                    end
                end 
            end
        end
        
        if y==2 | y==4 % schooling decisions + enrollment
                                          
            k=k+1;

            %%% Expected Next Period Life-Time Rewards
            VsS =MyLinear(Uc,K2,K0,squeeze(Vs (:,:,k+1,:,y))  ,Hets,Ab2s,Ab0s,'linear');
            VwuS=MyLinear(Uc,K2,K0,squeeze(Vwu(:,:,k+1,:,1,y)),Hets,Ab2s,Ab0s,'linear');        

            auxswu=Epss(:,k+1)>(VwuS-VsS);            
            
            Stas(:,y)=((Stas(:,z)==1).*(Quas(:,y)==k).*auxswu)*1 +...
            ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-auxswu).*DtaS    +(Stas(:,z)==1).*(1-(Quas(:,y)==k)).*DtaS    +...
             (Stas(:,z)==2).*(1-PhiS)+(Stas(:,z)==3).*DtaS    )*2+...
            ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-auxswu).*(1-DtaS)+(Stas(:,z)==1).*(1-(Quas(:,y)==k)).*(1-DtaS)+...
             (Stas(:,z)==2).*PhiS    +(Stas(:,z)==3).*(1-DtaS))*3;
     
            Typs(:,y)=...
           ((Stas(:,z)==1).*(Quas(:,y)==k).*auxswu)                         *((y==2)*7+(y==4)*13)+...
           ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-auxswu).*DtaS)               *((y==2)*8+(y==4)*14)+...
           ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-auxswu).*(1-DtaS))           *((y==2)*10+(y==4)*16)+...           
           ((Stas(:,z)==1).*(1-(Quas(:,y)==k)).*DtaS)                       *((y==2)*9+(y==4)*15)+...
           ((Stas(:,z)==1).*(1-(Quas(:,y)==k)).*(1-DtaS))                   *((y==2)*11+(y==4)*17)+...           
           ((Stas(:,z)==2).*(1-PhiS))                                       *1+...
           ((Stas(:,z)==2).*PhiS)                                           *4+...
           ((Stas(:,z)==3).*DtaS    )                                       *2+...
           ((Stas(:,z)==3).*(1-DtaS))                                       *3;

           Schs(:,y)=(Stas(:,y)==1).*(Schs(:,z)+1)+(1-(Stas(:,y)==1))*0;         
           
       elseif y==3 | y==5 | y==6 % schooling enrollment
       
           Stas(:,y)=...
            (Stas(:,z)==1)*1+...
            ((Stas(:,z)==2).*(1-PhiS)+(Stas(:,z)==3).*DtaS)*2+...
            ((Stas(:,z)==2).*PhiS    +(Stas(:,z)==3).*(1-DtaS))*3;
    
           Typs(:,y)=...
            (Stas(:,z)==1)                                                  *((y==3)*12+(y==5|y==6)*18)+...
            ((Stas(:,z)==2).*(1-PhiS))                                      *1+...
            ((Stas(:,z)==3).*DtaS)                                          *2+...
            ((Stas(:,z)==2).*PhiS)                                          *4+...
            ((Stas(:,z)==3).*(1-DtaS))                                      *3;

           Schs(:,y)=(Stas(:,y)==1).*(Schs(:,z))+(1-(Stas(:,y)==1))*0;            
        
       elseif y==7  % end of max schooling     
                   
            k=k+1;
                   
           Stas(:,y)=...
            ((Stas(:,z)==1).*(Quas(:,y)==k).*DtaS +(Stas(:,z)==1).*(1-(Quas(:,y)==k)).*DtaS+...
            (Stas(:,z)==2).*(1-PhiS)+ (Stas(:,z)==3).*DtaS)*2+...
            ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-DtaS)+(Stas(:,z)==1).*(1-(Quas(:,y)==k)).*(1-DtaS)+...
            (Stas(:,z)==2).*PhiS+(Stas(:,z)==3).*(1-DtaS))*3;

           Typs(:,y)=...
            ((Stas(:,z)==1).*(Quas(:,y)==k).*DtaS)                          *19 +...
            ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-DtaS))                      *20+...
            ((Stas(:,z)==2).*(1-PhiS))                                      *1+...
            ((Stas(:,z)==2).*PhiS)                                          *4+...
            ((Stas(:,z)==3).*DtaS)                                          *2+...            
            ((Stas(:,z)==3).*(1-DtaS))                                      *3;

       elseif y>7 % work - unemployement only
       
           Stas(:,y)=...
            ((Stas(:,z)==2).*(1-PhiS)+(Stas(:,z)==3).*DtaS)*2+...
            ((Stas(:,z)==2).*PhiS    +(Stas(:,z)==3).*(1-DtaS))*3;       

           Typs(:,y)=...
            ((Stas(:,z)==2).*(1-PhiS))                                      *1+...
            ((Stas(:,z)==3).*DtaS)                                          *2+...
            ((Stas(:,z)==2).*PhiS)                                          *4+...
            ((Stas(:,z)==3).*(1-DtaS))                                      *3;       
        
       end
       
       Stts(:,yy)=Stas(:,y);
       Trns(:,yy)=Typs(:,y);
       
       if y==8 | y==19 | y==27 % wage    
           %%% Rewards
           RwS=MyLinear(Uc,K2,Sc,K0,Xc,Rw,Hets,Ab2s,Quas(:,y),Ab0s,Exps(:,y),'linear');
           
           indD=find(Stas(:,y)==2); % working 
           if size(indD,1)>0
               x=zeros(nn,1); % initialize shocks vector
               randn('seed',y*11);
               x(indD,1)=randn(size(indD,1),1)*sigU;             
               Wags(indD,y)=exp(RwS(indD)+x(indD));
           end              
       end
       
    end
end
        
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% RESHAPE DATA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Schs=Schs'; 
Prds=Prds';
Stas=Stas';
Quas=Quas';
Exps=Exps';
Typs=Typs';
Ab2s=Ab2s';
Ab0s=Ab0s';
Wags=Wags';
Hets=Hets';

Stts=Stts';
Qlfs=Qlfs';
Trns=Trns';

Schs=reshape(Schs,[nn*np,1]);
Prds=reshape(Prds,[nn*np,1]);
Stas=reshape(Stas,[nn*np,1]);
Quas=reshape(Quas,[nn*np,1]);
Exps=reshape(Exps,[nn*np,1]);
Typs=reshape(Typs,[nn*np,1]);
Wags=reshape(Wags,[nn*np,1]);

Stts=reshape(Stts,[nn*np,1]);
Qlfs=reshape(Qlfs,[nn*np,1]);

ids=reshape(ids,[nn*np,1]);
Ab2s=repmat(Ab2s,[np,1]);
Ab2s=reshape(Ab2s,[nn*np,1]);
Ab0s=repmat(Ab0s,[np,1]);
Ab0s=reshape(Ab0s,[nn*np,1]);
Hets=repmat(Hets,[np,1]);
Hets=reshape(Hets,[nn*np,1]);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% SIMULATED DATA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  

%%% save last period data (can't save Tmat data as they would come from
% different individuals. 

save TversionXVI...
    ids Ab2s Ab0s Prds Stas Schs Quas Typs Wags Exps; 

% [ids Ab2s Ab0s Prds Stas Schs Quas Typs Wags Exps] 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% STATISTICS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%      

Smat=zeros(3,1,np);
Qmat=zeros(dimSc,1,np);
Tmat=zeros(20,1,np);
TmatH=zeros(20,dimUc,np);
Wmat=zeros(dimSc+1,1,3);
Kmat=zeros(dimSc,1,3);

i=1; % loop index used in Wages matrix

% Status 
for y=1:np
    for z=1:3 % 3 status: 1 school, 2 work, 3 unemployment 
        Smat(z,1,y)=sum(Stts(find(Prds==y))==z)/nn;   
    end

% Qualification
    for z=0:dimSc % 4 schooling levels : 0 No Qual, 1 O Lev, 2 A Lev, 3 HE
        Qmat(z+1,1,y)=sum(Qlfs(find(Prds==y))==z)/nn;   
    end

% Transitions. overall; by u.h.;
    for z=1:20 % 20 transitions 
        Tmat(z,1,y)=sum(Trns(find(Prds==y))==z)/nn;   
        for j=1:dimUc
            TmatH(z,j,y)=sum(Trns(find(Prds==y&Hets==(j-1)))==z)/sum(Prds==y&Hets==(j-1));  
        end
    end
    
    % Wages. means by: unconditional; period; education; education&period;
    if y==8 | y==19 | y==27
        Wmat(1,1,i)=mean(Wags(find(Wags~=0))); % unconditional (identical over i loop)
        Wmat(1,2,i)=mean(Wags(find(Prds==y&Wags~=0))); % by period

         for z=0:dimSc-1
            Wmat(z+2,1,i)=mean(Wags(find(Wags~=0&Quas==z))); % by education (identical over i loop)
            Wmat(z+2,2,i)=mean(Wags(find(Prds==y&Wags~=0&Quas==z))); % by education & period
            Kmat(z+1,1,i)=mean(Ab2s(find(Prds==y&Quas==z)));
        end
        i=i+1; % loop is over period. can not use y={9,19,27}
    end
    
end


Smat(end+1,:,:)=sum(Smat); 
Qmat(end+1,:,:)=sum(Qmat); 
Tmat(end+1,:,:)=sum(Tmat); 
TmatH(end+1,:,:)=sum(TmatH); 

% Education by skills
xAb2=prctile(Ab2s(find(Prds==8)),[20:20:100]); % define prctiles (quintiles)
xAb0=prctile(Ab0s(find(Prds==8)),[20:20:100]);

j=1;
for i=1:length(xAb2) %loop over pctiles values
    for k=0:max(Quas) % loop over qualifications
        if i==1 
            
            a=find(Ab2s<=xAb2(i)&Prds==8); % define set of individuals
            QK2mat(j,k+2)=sum(Quas(a)==k)/length(a); % compute rate within set
            
            for h=[1:dimUc] % loop over types
                a=find((Ab2s<=xAb2(i))&(Prds==8)&(Hets==h-1)); % define set of individuals
                QK2Hmat(j,k+2,h)=sum(Quas(a)==k)/length(a); % compute rate within set
            end
            
        else
            a=find(Ab2s>xAb2(i-1)&Ab2s<=xAb2(i)&Prds==8); % define set of individuals
            QK2mat(j,k+2)=sum(Quas(a)==k)/length(a); % compute rate within set
            
            for h=[1:dimUc] % loop over types
                a=find((Ab2s>xAb2(i-1))&(Ab2s<=xAb2(i))&(Prds==8)&(Hets==h-1)); % define set of individuals
                QK2Hmat(j,k+2,h)=sum(Quas(a)==k)/length(a); % compute rate within set
            end

        end
    end
    
%     QK2mat(j,1)=xAb2(i);
%     QK2Hmat(j,1,:)=xAb2(i);
    QK2mat(j,1)=i;
    QK2Hmat(j,1,:)=i;
    j=j+1;
end


j=1;
for i=1:length(xAb0) %loop over pctiles values
    for k=0:max(Quas) % loop over qualifications
        if i==1 
            
            a=find(Ab0s<=xAb0(i)&Prds==8); % define set of individuals
            QK0mat(j,k+2)=sum(Quas(a)==k)/length(a); % compute rate within set
            
            for h=[1:dimUc] % loop over types
                a=find((Ab0s<=xAb0(i))&(Prds==8)&(Hets==h-1)); % define set of individuals
                QK0Hmat(j,k+2,h)=sum(Quas(a)==k)/length(a); % compute rate within set
            end
            
        else
            a=find(Ab0s>xAb0(i-1)&Ab0s<=xAb0(i)&Prds==8); % define set of individuals
            QK0mat(j,k+2)=sum(Quas(a)==k)/length(a); % compute rate within set
            
            for h=[1:dimUc] % loop over types
                a=find((Ab0s>xAb0(i-1))&(Ab0s<=xAb0(i))&(Prds==8)&(Hets==h-1)); % define set of individuals
                QK0Hmat(j,k+2,h)=sum(Quas(a)==k)/length(a); % compute rate within set
            end

        end
    end
    
%     QK0mat(j,1)=xAb0(i);
%     QK0Hmat(j,1,:)=xAb0(i);
    QK0mat(j,1)=i;
    QK0Hmat(j,1,:)=i;
    j=j+1;
end

% Wages by education and u.h.
for q=1:dimSc
    for h=1:dimUc
        WHmat(q,h)=mean(Wags(find((Wags~=0)&(Quas==q-1)&(Hets==h-1))));
    end
end

% Wages by education and experience
for i=1:dimXc
    WXmat(i,1)=i;
    for j=0:dimSc-1
        a=find(Wags~=0&Exps==i&Quas==j);
        if length(a)>0
            WXmat(i,j+2)=mean(Wags(a));
        else
            WXmat(i,j+2)=0;
        end
    end
end
