function [Smat,Qmat,Tmat,Vlife]=f_psimulation(x)

% This function simulates the data using the initial (Period 1) distribution of 
% Skill age 16 and Skill age 7. It is not identical to SIMULATION_XI because it does
% not adjust the distributions period by period. There is also an initial SUBSIDY
% section that defines the parameters as a function of the subsidy.

global dimSc dimUc
global K2 K0 Sc Xc Uc 
global beta
global AbMat
global nn np

global Ab2 Ab0 Prd
global THETA
global subsidy
global subY
global tTHF pk

a=tTHF;

sigE1=THETA(a+1); 
sigE2=THETA(a+2); 
sigE3=THETA(a+3); 

%% SUBSIDY

if subsidy>=0 && subsidy<=3

    %%% State variables
    K2=MyGrid(Ab2,[0 10 25 33 50 66 75 90 100]);     % Skill age 16  grid (0,1,2...)
    for i=1:np % define Skill age 16 and Skill age 7 data distributions
        AbMat{i}=MyTabulate2(Ab2(Prd==1),Ab0(Prd==1));   
    end

elseif subsidy==4 % Ab2 subsidy

    Ab2N=Ab2+x*subY;
    K2=MyGrid(Ab2N,[0 10 25 33 50 66 75 90 100]);     % Skill age 16  grid (0,1,2...)
    for i=1:np % define Skill age 16 and Skill age 7 data distributions
        AbMat{i}=MyTabulate2(Ab2N(Prd==1),Ab0(Prd==1));   
    end
    
elseif subsidy==5 % Ab0->Ab2 subsidy

    Ab0N=Ab0+x*subY;
    Ab2N=Ab2+0.643*(x*subY);
    K2=MyGrid(Ab2N,[0 10 25 33 50 66 75 90 100]);     % Skill age 16  grid (0,1,2...)    
    K0=MyGrid(Ab0N,[0 10 25 33 50 66 75 90 100]);     % Skill age 16  grid (0,1,2...)
    for i=1:np % define Skill age 16 and Skill age 7 data distributions
        AbMat{i}=MyTabulate2(Ab2N(Prd==1),Ab0N(Prd==1));   
    end

end

%% PARAMETERS

sigU    = abs(THETA(1))    ;   % s.d error term in observed Wage

%% SIMULATION

% Generate shocks

% Shock to simulate e in Rs
randn('seed',100);      % set seed of randon number generator (normal distribution)
x1=randn(nn,np);         % generate random numbers (for every individual / period)

% Shock to simulate unobserved heterogeneity 
rand('seed',7314);      % set seed of randon number generator (uniform distribution)
x4=rand(nn,1);          % generate random numbers (for every individual)

%%% Generate Simulated Variables
Epss=[x1(:,1)*sigE1 x1(:,2)*sigE2  x1(:,3)*sigE3];     % define shocks for Rs

Schs=zeros(nn,np);          % Schooling: initialize
Quas=zeros(nn,np);          % Qualification variables
Typs=zeros(nn,np);          % Type: initialize
Stas=zeros(nn,np);          % Status: initialize
Exps=zeros(nn,np);          % Experience: initialize
Wags=zeros(nn,np);          % Wage: initialize
Prds=repmat(1:np,[nn,1]);   % Periods
ids=repmat(1:nn,[np,1]);    % id

%% SOLVE MODEL

[Rw,Lam,Dta,Dta1,Phi,Vs,Vu,Vwu]=f_pmodel(x); 

%% CHOICES

HetMat=[Uc ones(length(Uc),1) pk*100]; % Unobserved Heterogeneity 
Hets=MySimulvar(HetMat,x4,nn);

[Ab2s Ab0s]=MySimulvar2(AbMat{1},nn); % simulated Skill age 16 from shock

% Period 1 - age 15 / O Lev

% Expected Next Period Life-Time Rewards
VsS =MyLinear(Uc,K2,K0,squeeze(Vs(:,:,1,:,1))    ,Hets,Ab2s,Ab0s,'linear');
VwuS=MyLinear(Uc,K2,K0,squeeze(Vwu(:,:,1,:,1,2)) ,Hets,Ab2s,Ab0s,'linear');

Vlife=[max(beta*VwuS,VsS+Epss(:,1)),Ab2s,Ab0s,Hets]; % lifetime max wealth
    
auxsu=Epss(:,1)>(beta*VwuS-VsS);
Stas(:,1)=auxsu*1+(1-auxsu)*3;  % choice S0 -> S1/W
Typs(:,1)=auxsu*5+(1-auxsu)*6;
Schs(:,1)=auxsu*1+(1-auxsu)*0;

k=0;  % educational success

for y=2:np
    % Period 2 onwards

    z=y-1;  % lagged period

    Exps(:,y)=Exps(:,z)+(Stas(:,z)==2); % experience
    Quas(:,y)=Quas(:,z); % qualification

    % update qualification
    if y==2 || y==4 || y==7   % select periods when qualification can be gained
        LamS=normcdf(MyLinear(Uc,K2,Sc(1:dimSc-1),K0,Lam,Hets,Ab2s,Quas(:,y),Ab0s,'linear'));            
        for i=[AbMat{y}{2}]' % loop over Skill age 16  values (keep transpose to get loop)       
            for j=[AbMat{y}{3}]' % loop over Skill age 7 values (keep transpose to get loop)   
                for h=0:1:dimUc-1 % loop over u.h.
                    indL=find((Ab2s==i)&(Ab0s==j)&(Stas(:,z)==1)&(Hets==h)); % define individuals who entered exams
                    if size(indL,1)>0
                        x=zeros(nn,1); % initialize shocks vector
                        randn('seed',((i+j)^y)*12); % generate normal shocks 
                        x(indL,1)=randn(size(indL,1),1);
                        Quas(indL,y)=Quas(indL,y)+(x(indL)>norminv((1-LamS(indL)))); % generate Quas|S1 to match data
                    end
                end
            end
        end      
    end

    % assign job offer and job firing 
    DtaS=zeros(nn,1);    % initialize job offers vector - Dta is dK dS dY dP dX
    PhiS=zeros(nn,1);    % initialize job firing vector - Phi is dK dS dY dP dX
    D =normcdf(MyLinear(Uc,K2,Sc,K0,Xc,Dta ,Hets,Ab2s,Quas(:,y),Ab0s,Exps(:,y),'linear'));
    D1=normcdf(MyLinear(Uc,K2,Sc,K0,Xc,Dta1,Hets,Ab2s,Quas(:,y),Ab0s,Exps(:,y),'linear'));
    P =normcdf(MyLinear(Uc,K2,Sc,K0,Xc,Phi ,Hets,Ab2s,Quas(:,y),Ab0s,Exps(:,y),'linear'));        
    for i=0:max(Quas(:,y))
        for j=0:max(Exps(:,y))
            for h=0:1:dimUc-1 % loop over u.h.
                % job offer
                indD=find((Quas(:,y)==i)&(Exps(:,y)==j)&(Stas(:,z)~=2)&(Hets==h)); % not working before
                if size(indD,1)>0
                    x=zeros(nn,1); % initialize shocks vector                   
                    randn('seed',((i+2)^(j+2))*y*11);
                    x(indD,1)=randn(size(indD,1),1);
                    if y==2
                        DtaS(indD)=(x(indD)>norminv((1-D1(indD)))); % generate job offer
                    else
                        DtaS(indD)=(x(indD)>norminv((1-D(indD)))); % generate job offer
                    end
                end                              
                % job firing
                indP=find((Quas(:,y)==i)&(Exps(:,y)==j)&(Stas(:,z)==2)&(Hets==h)); % working before
                if size(indP,1)>0
                    x=zeros(nn,1); % initialize shocks vector                   
                    randn('seed',((i+2)^(j+2))*y*3);
                    x(indP,1)=randn(size(indP,1),1);
                    PhiS(indP)=(x(indP)>norminv((1-P(indP)))); % generate job firing
                end 
            end
        end           
    end 
    
    if y==2 || y==4 % schooling decisions + enrollment
    
        k=k+1;
    
        % Expected Next Period Life-Time Rewards
        VsS =MyLinear(Uc,K2,K0,squeeze(Vs(:,:,k+1,:,y))   ,Hets,Ab2s,Ab0s,'linear');
        VwuS=MyLinear(Uc,K2,K0,squeeze(Vwu(:,:,k+1,:,1,y)),Hets,Ab2s,Ab0s,'linear');        
                              
        auxswu=Epss(:,k+1)>(VwuS-VsS);
    
        Stas(:,y)=((Stas(:,z)==1).*(Quas(:,y)==k).*auxswu)*1 +...
        ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-auxswu).*DtaS    +(Stas(:,z)==1).*(1-(Quas(:,y)==k)).*DtaS    +...
         (Stas(:,z)==2).*(1-PhiS)+(Stas(:,z)==3).*DtaS    )*2+...
        ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-auxswu).*(1-DtaS)+(Stas(:,z)==1).*(1-(Quas(:,y)==k)).*(1-DtaS)+...
         (Stas(:,z)==2).*PhiS    +(Stas(:,z)==3).*(1-DtaS))*3;
    
        Typs(:,y)=...
       ((Stas(:,z)==1).*(Quas(:,y)==k).*auxswu)                         *((y==2)*7+(y==4)*13)+...
       ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-auxswu).*DtaS)               *((y==2)*8+(y==4)*14)+...
       ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-auxswu).*(1-DtaS))           *((y==2)*10+(y==4)*16)+...
       ((Stas(:,z)==1).*(1-(Quas(:,y)==k)).*DtaS)                       *((y==2)*9+(y==4)*15)+...
       ((Stas(:,z)==1).*(1-(Quas(:,y)==k)).*(1-DtaS))                   *((y==2)*11+(y==4)*17)+...
       ((Stas(:,z)==2).*(1-PhiS))                                       *1+...
       ((Stas(:,z)==2).*PhiS)                                           *4+...
       ((Stas(:,z)==3).*DtaS    )                                       *2+...
       ((Stas(:,z)==3).*(1-DtaS))                                       *3;
    
       Schs(:,y)=(Stas(:,y)==1).*(Schs(:,z)+1)+(1-(Stas(:,y)==1))*0;
    
    elseif y==3 || y==5 || y==6 % schooling enrollment
    
        Stas(:,y)=...
         (Stas(:,z)==1)*1+...
         ((Stas(:,z)==2).*(1-PhiS)+(Stas(:,z)==3).*DtaS)*2+...
         ((Stas(:,z)==2).*PhiS    +(Stas(:,z)==3).*(1-DtaS))*3;
    
        Typs(:,y)=...
         (Stas(:,z)==1)                                                  *((y==3)*12+(y==5|y==6)*18)+...
         ((Stas(:,z)==2).*(1-PhiS))                                      *1+...
         ((Stas(:,z)==3).*DtaS)                                          *2+...
         ((Stas(:,z)==2).*PhiS)                                          *4+...
         ((Stas(:,z)==3).*(1-DtaS))                                      *3;
    
        Schs(:,y)=(Stas(:,y)==1).*(Schs(:,z))+(1-(Stas(:,y)==1))*0;
    
    elseif y==7  % end of max schooling
    
        k=k+1;
    
        Stas(:,y)=...
         ((Stas(:,z)==1).*(Quas(:,y)==k).*DtaS +(Stas(:,z)==1).*(1-(Quas(:,y)==k)).*DtaS+...
         (Stas(:,z)==2).*(1-PhiS)+ (Stas(:,z)==3).*DtaS)*2+...
         ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-DtaS)+(Stas(:,z)==1).*(1-(Quas(:,y)==k)).*(1-DtaS)+...
         (Stas(:,z)==2).*PhiS+(Stas(:,z)==3).*(1-DtaS))*3;
    
        Typs(:,y)=...
         ((Stas(:,z)==1).*(Quas(:,y)==k).*DtaS)                          *19 +...
         ((Stas(:,z)==1).*(Quas(:,y)==k).*(1-DtaS))                      *20+...
         ((Stas(:,z)==2).*(1-PhiS))                                      *1+...
         ((Stas(:,z)==2).*PhiS)                                          *4+...
         ((Stas(:,z)==3).*DtaS)                                          *2+...
             ((Stas(:,z)==3).*(1-DtaS))                                      *3;
    
    elseif y>7 % work - unemployement only
    
        Stas(:,y)=...
         ((Stas(:,z)==2).*(1-PhiS)+(Stas(:,z)==3).*DtaS)*2+...
         ((Stas(:,z)==2).*PhiS    +(Stas(:,z)==3).*(1-DtaS))*3;
    
        Typs(:,y)=...
         ((Stas(:,z)==2).*(1-PhiS))                                      *1+...
         ((Stas(:,z)==3).*DtaS)                                          *2+...
         ((Stas(:,z)==2).*PhiS)                                          *4+...
         ((Stas(:,z)==3).*(1-DtaS))                                      *3;
    
    end
    
    if y==8 || y==19 || y==27 % wage
       % Rewards
       RwS=MyLinear(Uc,K2,Sc,K0,Xc,Rw,Hets,Ab2s,Quas(:,y),Ab0s,Exps(:,y),'linear');
    
        indD=find(Stas(:,y)==2); % working
        if size(indD,1)>0
            x=zeros(nn,1); % initialize shocks vector
            randn('seed',y*11);
            x(indD,1)=randn(size(indD,1),1)*sigU;
            Wags(indD,y)=exp(RwS(indD)+x(indD));
        end
    end
    
end

%% RESHAPE DATA

Schs=Schs';
Prds=Prds';
Stas=Stas';
Quas=Quas';
Exps=Exps';
Typs=Typs';
Ab2s=Ab2s';
Ab0s=Ab0s';
Wags=Wags';

Schs=reshape(Schs,[nn*np,1]);
Prds=reshape(Prds,[nn*np,1]);
Stas=reshape(Stas,[nn*np,1]);
Quas=reshape(Quas,[nn*np,1]);
Exps=reshape(Exps,[nn*np,1]);
Typs=reshape(Typs,[nn*np,1]);
Wags=reshape(Wags,[nn*np,1]);

ids=reshape(ids,[nn*np,1]);
Ab2s=repmat(Ab2s,[np,1]);
Ab2s=reshape(Ab2s,[nn*np,1]);
Ab0s=repmat(Ab0s,[np,1]);
Ab0s=reshape(Ab0s,[nn*np,1]);
% Hets=repmat(Hets,[np,1]);
% Hets=reshape(Hets,[nn*np,1]);

%% SIMULATED DATA

% save last period data (can't save Tmat data as they would come from
% different individuals.

save TversionXVI...
    ids Ab2s Ab0s Prds Stas Schs Quas Typs Wags Exps;

% [ids Ab2s Ab0s Prds Stas Schs Quas Typs Wags Exps]

%% STATISTICS

Smat=zeros(3,1,np);
Qmat=zeros(dimSc+1,1,np);
Tmat=zeros(20,1,np);

% Status
for y=1:np
    for z=1:3 % 3 status: 1 school, 2 work, 3 unemployment
        Smat(z,1,y)=sum(Stas(Prds==y)==z)/nn;
    end

% Qualification
    for z=0:dimSc % 4 schooling levels : 0 No Qual, 1 O Lev, 2 A Lev, 3 HE
        Qmat(z+1,1,y)=sum(Quas(Prds==y)==z)/nn;
    end

% Transition
    for z=1:20 % 20 transitions
        Tmat(z,1,y)=sum(Typs(Prds==y)==z)/nn;
    end

end


Smat(end+1,:,:)=sum(Smat);
Qmat(end+1,:,:)=sum(Qmat);
Tmat(end+1,:,:)=sum(Tmat);
