function [Vs,Vu,Vwu,Rss]=f_modelSCH(THETA,tut,THETAF)

% VERSION X

global dimK2 dimK0 dimSc dimEc dimXc dimTc dimUc
global K2 K0 Xc
global beta
global scale
global tWAG tLAM tDTA tPHI 

sigE1=THETA(01); 
sigE2=THETA(02); 
sigE3=THETA(03); 

%% PARAMETERS

ThetaWAG=THETAF(1                           :tWAG);
ThetaLAM=THETAF(tWAG+1                      :tWAG+tLAM);
ThetaDTA=THETAF(tWAG+tLAM+1                 :tWAG+tLAM+tDTA);
ThetaPHI=THETAF(tWAG+tLAM+tDTA+1            :tWAG+tLAM+tDTA+tPHI);

g1_01   = THETA(04);   % Rs coeff: O Levels in school reward 
g1_02   = THETA(04)+THETA(end-1);
g1_03   = THETA(04)-THETA(end);
g1_K2   = 0;%THETA(03);   % Rs coeff: O Levels in school reward 
g1_K0   = 0;%THETA(04);   % Rs coeff: O Levels in school reward 

g2_00   = THETA(05);   % Rs coeff: A Levels in school reward 
g2_K2   = 0;%THETA(05);   % Rs coeff: A Levels in school reward 
g2_K0   = 0;%THETA(06);   % Rs coeff: A Levels in school reward 

g3_00   = THETA(06);   % Rs coeff: HE Levels in school reward 
g3_K2   = 0;%THETA(08);   % Rs coeff: HE Levels in school reward 
g3_K0   = 0;%THETA(09);   % Rs coeff: HE Levels in school reward 

gm_Uc=[g1_01, g1_02, g1_03]';          % dUc
gm_Sc=[0, g2_00, g3_00]';       % dSc-1 (vector of returns to schooling in Rs)
gm_K2=[g1_K2, g2_K2, g3_K2]';   % dSc-1 (vector of returns to skill 16  in Rs)
gm_K0=[g1_K0, g2_K0, g3_K0]';   % dSc-1 (vector of returns to skill 7 in Rs)

%% STATE VARIABLES

% Shocks
[piU,eps,Ec1]=tauchen(dimEc,0,0,sigE1);
[piU,eps,Ec2]=tauchen(dimEc,0,0,sigE2);
[piU,eps,Ec3]=tauchen(dimEc,0,0,sigE3);
Ec=[Ec1 Ec2 Ec3]; %

%% REWARDS

% Rs schooling reward

% School coeffs aux matrix
auxRsUc=repmat(gm_Uc,[1 dimK2 dimSc-1 dimK0 dimEc]);                % dUc dK2 dSc-1 dK0 dEc

% Tuition fees aux matrix
auxRsTu=repmat(tut,[1 dimUc dimK2 dimK0 dimEc]);                    % dSc-1 dUc dK2 dK0 dEc 
auxRsTu=permute(auxRsTu,[2 3 1 4 5]);                               % dUc dK2 dSc-1 dK0 dEc

% School coeffs aux matrix
auxRs00=repmat(gm_Sc,[1 dimUc dimK2 dimK0 dimEc]);                  % dSc-1 dUc dK2 dK0 dEc
auxRs00=permute(auxRs00,[2 3 1 4 5]);                               % dUc dK2 dSc-1 dK0 dEc

% Skill age 16 returns aux matrix
auxRsK2=gm_K2*K2';                                                  % dSc-1 dK2
auxRsK2=repmat(auxRsK2,[1 1 dimUc dimK0 dimEc]);                    % dSc-1 dK2 dUc dK0 dEc
auxRsK2=permute(auxRsK2,[3 2 1 4 5]);                               % dUc dK2 dSc-1 dK0 dEc

% Skill age 7 returns aux matrix
auxRsK0=gm_K0*K0';                                                  % dSc-1 dK0
auxRsK0=repmat(auxRsK0,[1 1 dimUc dimK2 dimEc]);                    % dSc-1 dK0 dUc dK2 dEc
auxRsK0=permute(auxRsK0,[3 4 1 2 5]);                               % dUc dK2 dSc-1 dK0 dEc

% Shocks aux matrix
auxRsEc=repmat(Ec,[1 1 dimUc dimK2 dimK0]);                         % dEc dSc-1 dUc dK2 dK0
auxRsEc=permute(auxRsEc,[3 4 2 5 1]);                               % dUc dK2 dSc-1 dK0 dEc

Rs=auxRsUc-auxRsTu+auxRs00+auxRsK2+auxRsK0+auxRsEc;                 % dUc dK2 dSc-1 dK0 dEc
Rs(:,:,dimSc,:,:)=-1e+300;                                          % dUc dK2 dSc dK0 dEc

Rss=auxRsUc-auxRsTu+auxRs00+auxRsK2+auxRsK0;                        % dUc dK2 dSc-1 dK0 dEc
Rss(:,:,dimSc,:,:)=-1e+300;                                         % dUc dK2 dSc dK0 dEc

clear auxRsUc auxRsTu auxRs00 auxRsK2 auxRsK0 auxRsEc

% Compute Expected Reward
ERs=mean(Rs,5);                                                     % dUc dK2 dSc dK0

% Rw unemployment reward
Rw=f_modelWAG(ThetaWAG);                                           % dUc dK2 dSc dK0 dXc
Rw=exp(Rw);                                                         % dUc dK2 dSc dK0 dXc

% Ru unemployment reward
Ru=3000/scale;                                                     

%% PROBABILITIES

[Lam]=f_modelLAM(ThetaLAM);                         
[Dta,Dta1]=f_modelDTA(ThetaDTA);
[Phi]=f_modelPHI(ThetaPHI);

Lam=MyNormcdf(Lam);                                                 % dUc dK2 dSc-1 dK0 dXc     
Dta=MyNormcdf(Dta); Dta1=MyNormcdf(Dta1);                           % dUc dK2 dSc dK0 dXc                         
Phi=MyNormcdf(Phi);                                                 % dUc dK2 dSc dK0 dXc

%% VALUE FUNCTIONS

if beta~=0
    
    % Initialize Value Function matrices
    Vs =zeros(dimUc,dimK2,dimSc,dimK0,dimEc,dimTc); % dUc dK2 dSc dK0 dEc dTc - Value Function from education
    Vw =zeros(dimUc,dimK2,dimSc,dimK0,dimXc,dimTc); % dUc dK2 dSc dK0 dXc dTc - Value Function from working
    Vu =zeros(dimUc,dimK2,dimSc,dimK0,dimXc,dimTc); % dUc dK2 dSc dK0 dXc dTc - Value Function from unemployment

    Vwu=zeros(dimUc,dimK2,dimSc,dimK0,dimXc,dimTc); % dUc dK2 dSc dK0 dXc dTc - Value Function from work/unemployment
    Vss=Vs; % dUc dK2 dSc dK0 dEc dTc - Value Function from education net of taste shock

    for i=dimTc:-1:1;    
        
        if i==dimTc

            Vw(:,:,:,:,:,i)=Rw; % dUc dK2 dSc dK0 dXc dTc  
            Vu(:,:,:,:,:,i)=Ru; % dUc dK2 dSc dK0 dXc dTc 
        
        elseif i<dimTc

            %% FUTURE PAYOFFS %%
    
            % EnextVw
            w1X=(diff(Xc)-1)./diff(Xc); % left hand side weigths
            w2X=1./diff(Xc); % right hand side weigths
            w1X=repmat(w1X,[1,dimUc,dimK2,dimSc,dimK0]); % dXc-1 dUc dK2 dSc dK0
            w1X=permute(w1X,[2 3 4 5 1]); % dUc dK2 dSc dK0 dXc-1 
            w2X=repmat(w2X,[1,dimUc,dimK2,dimSc,dimK0]); % dXc-1 dUc dK2 dSc dK0
            w2X=permute(w2X,[2 3 4 5 1]); % dUc dK2 dSc dK0 dXc-1 
    
            auxPhi_w=w1X.*Phi(:,:,:,:,1:end-1)+w2X.*Phi(:,:,:,:,2:end); % dUc dK2 dSc dK0 dXc-1 
            auxVw_w=w1X.*Vw(:,:,:,:,1:end-1,i+1)+w2X.*Vw(:,:,:,:,2:end,i+1); % dUc dK2 dSc dK0 dXc-1 
            auxVu_w=w1X.*Vu(:,:,:,:,1:end-1,i+1)+w2X.*Vu(:,:,:,:,2:end,i+1); % dUc dK2 dSc dK0 dXc-1 
    
            auxPhi_w=cat(5,auxPhi_w,Phi(:,:,:,:,end)); % dUc dK2 dSc dK0 dXc
            auxVw_w=cat(5,auxVw_w,Vw(:,:,:,:,end,i+1)); % dUc dK2 dSc dK0 dXc
            auxVu_w=cat(5,auxVu_w,Vu(:,:,:,:,end,i+1)); % dUc dK2 dSc dK0 dXc    
            EnextVw=auxPhi_w.*auxVu_w+(1-auxPhi_w).*auxVw_w; % dUc dK2 dSc dK0 dXc
            
            clear w1X w2X auxPhi_w auxVw_w auxVu_w
    
            % EnextVu
            if i==1
                EnextVu=Dta1.*Vw(:,:,:,:,:,i+1)+(1-Dta1).*Vu(:,:,:,:,:,i+1); % dUc dK2 dSc dK0 dXc
            else
                EnextVu=Dta .*Vw(:,:,:,:,:,i+1)+(1-Dta) .*Vu(:,:,:,:,:,i+1); % dUc dK2 dSc dK0 dXc
            end

            % EnextVs: take leave education VF
        
            if i==6 % 3rd year HE
                auxEnextVs=Lam(:,:,3,:).*EnextVu(:,:,4,:,1)+(1-Lam(:,:,3,:)).*EnextVu(:,:,3,:,1); % dUc dK2 dSc-3 dK0                
            elseif i==5 % 2nd year HE
                auxEnextVs=ERs(:,:,3,:)+beta*auxEnextVs; % dUc dK2 dSc-3 dK0
            elseif i==4 % 1nd year HE
                auxEnextVs=ERs(:,:,3,:)+beta*auxEnextVs; % dUc dK2 dSc-3 dK0
            elseif i==3 % 2nd year AL
                aux1_s=EnextVu(:,:,3,:,1); % dUc dK2 dSc-3 dK0
                aux2_s=repmat(aux1_s,[1 1 1 1 dimEc]); % dUc dK2 dSc-3 dK0 dEc
                aux3_s=max(Vs(:,:,3,:,:,i+1),aux2_s); % dUc dK2 dSc-3 dK0 dEc
                aux4_s=mean(aux3_s,5); % dUc dK2 dSc-3 dK0
                auxEnextVs=Lam(:,:,2,:).*aux4_s+(1-Lam(:,:,2,:)).*EnextVu(:,:,2,:,1); % dUc dK2 dSc-3 dK0
                clear aux1_s aux2_s aux3_s aux4_s
            elseif i==2 % 1st year AL
                auxEnextVs=ERs(:,:,2,:)+beta*auxEnextVs; % dUc dK2 dSc-3 dK0
            elseif i==1 % 1st year OL
                aux1_s=EnextVu(:,:,2,:,1); % dUc dK2 dSc-3 dK0
                aux2_s=repmat(aux1_s,[1 1 1 1 dimEc]); % dUc dK2 dSc-3 dK0 dEc
                aux3_s=max(Vs(:,:,2,:,:,i+1),aux2_s); % dUc dK2 dSc-3 dK0 dEc
                aux4_s=mean(aux3_s,5); % dUc dK2 dSc-3 dK0
                auxEnextVs=Lam(:,:,1,:).*aux4_s+(1-Lam(:,:,1,:)).*EnextVu(:,:,1,:,1); % dUc dK2 dSc-3 dK0 
                clear aux1_s aux2_s aux3_s aux4_s
            else
                auxEnextVs=zeros(dimUc,dimK2,1,dimK0); % dUc dK2 dSc-3 dK0
            end
        
            EnextVs=repmat(auxEnextVs,[1 1 dimSc 1 dimEc]); % dUc dK2 dSc dK0 dEc 
            EnextVs(:,:,dimSc,:,:)=0; % dUc dK2 dSc dK0 dEc       
    
            %% VALUE FUNCTIONS %%
            % flow of utility associated with each choice
            Vw(:,:,:,:,:,i)=Rw+beta*EnextVw; % dUc dK2 dSc dK0 dXc dTc
            Vu(:,:,:,:,:,i)=Ru+beta*EnextVu; % dUc dK2 dSc dK0 dXc dTc
            Vs(:,:,:,:,:,i)=Rs+beta*EnextVs; % dUc dK2 dSc dK0 dEc dTc
            
            if i==2
                Vwu(:,:,:,:,:,i)=Dta1.*Vw(:,:,:,:,:,i)+(1-Dta1).*Vu(:,:,:,:,:,i); % dUc dK2 dSc dK0 dXc dTc
            else
                Vwu(:,:,:,:,:,i)=Dta .*Vw(:,:,:,:,:,i)+(1-Dta) .*Vu(:,:,:,:,:,i); % dUc dK2 dSc dK0 dXc dTc
            end
            Vss(:,:,:,:,:,i)=Rss+beta*EnextVs; % dUc dK2 dSc dK0 dEc dTc

        end
    end
        
elseif beta==0
    
    % Initialize Value Function matrices
    Vs =repmat(Rs,[1,1,1,1,1,dimTc]); %#ok<NASGU> % dUc dK2 dSc dK0 dEc dTc - Value Function from education
    Vw =repmat(Rw,[1,1,1,1,1,dimTc]); %#ok<NASGU> % dUc dK2 dSc dK0 dXc dTc - Value Function from working
    Vu =repmat(Ru,[1,1,1,1,1,dimTc]); % dUc dK2 dSc dK0 dXc dTc - Value Function from unemployment

    Vwu=repmat(Dta.*Rw+(1-Dta).*Ru,[1,1,1,1,1,dimTc]); % dUc dK2 dSc dK0 dXc dTc - Value Function from work/unemployment
    Vss=repmat(Rss,[1,1,1,1,1,dimTc]); % dUc dK2 dSc dK0 dEc dTc - Value Function from education net of taste shock
    
end

%% Export
Vss=squeeze(Vss(:,:,:,:,1,:)); % dUc dK2 dSc dK0 dTc        
Vs=Vss; % dUc dK2 dSc dK0 dTc
