function [Phi]=f_modelPHI(THETA)

% VERSION IX

global dimK2 dimK0 dimSc dimEc dimXc dimYp dimTc dimUc
global K2 K0 Sc Yp Xc Tc Uc
global dimT tol
global beta tut1 tut2 tut3 rho

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% PARAMETERS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ph_01   = THETA(01) ;   % Constant in P(W) 
ph_02   = THETA(01)+THETA(end-1);
ph_03   = THETA(01)-THETA(end);
ph_K2   = THETA(02) ;   % K2 coeff in P(W)
ph_K0   = THETA(03) ;   % K0 coeff in P(W)
ph_S1   = THETA(04) ;   % Q1 coeff in P(W) 
ph_S2   = THETA(05) ;   % Q2 coeff in P(W) 
ph_S3   = THETA(06) ;   % Q3 coeff in P(W) 
ph_X1   = THETA(07) ;   % X1 coeff in P(W) 

ph_00=[ph_01, ph_02, ph_03]';  % dUc
ph_S=[0, ph_S1, ph_S2, ph_S3]'; % % dSc (vector of Schooling effect in P(W)) 

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% %%% PROBABILITIES
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

auxPh00=repmat(ph_00,[1 dimK2 dimSc dimK0 dimXc]);              % dUc dK2 dSc dK0 dXc
auxPhK2=K2*[ph_K2];                                                 % dK2 
auxPhK2=repmat(auxPhK2,[1 dimUc dimSc dimK0 dimXc]);                % dK2 dUc dSc dK0 dXc 
auxPhK2=permute(auxPhK2,[2 1 3 4 5]);                               % dUc dK2 dSc dK0 dXc 
auxPhK0=K0*[ph_K0];                                                 % dK0 
auxPhK0=repmat(auxPhK0,[1 dimUc dimK2 dimSc dimXc]);                % dK0 dUc dK2 dSc dXc 
auxPhK0=permute(auxPhK0,[2 3 4 1 5]);                               % dUc dK2 dSc dK0 dXc
auxPhSc=repmat(ph_S,[1 dimUc dimK2 dimK0 dimXc]);                   % dSc dUc dK2 dK0 dXc 
auxPhSc=permute(auxPhSc,[2 3 1 4 5]);                               % dUc dK2 dSc dK0 dXc
auxPhXc=Xc*[ph_X1];                                                 % dXc
auxPhXc=repmat(auxPhXc,[1 dimUc dimK2 dimSc dimK0]);                % dXc dUc dK2 dSc dK0
auxPhXc=permute(auxPhXc,[2 3 4 5 1]);                               % dUc dK2 dSc dK0 dXc
Phi =auxPh00+auxPhK2+auxPhSc+auxPhK0+auxPhXc;                       % dUc dK2 dSc dK0 dXc

clear auxPh00 auxPhK2 auxPhSc auxPhK0 auxPhXc
